% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIT_local.R
\name{PIT_local}
\alias{PIT_local}
\title{Obtain local PIT-values from a model}
\usage{
PIT_local(
  xcal,
  ycal,
  yhat,
  mse,
  clusters = 6,
  p_neighbours = 0.2,
  PIT = PIT_global
)
}
\arguments{
\item{xcal}{features/covariates from calibration set}

\item{ycal}{observations of calibration set}

\item{yhat}{predicted outputs from the calibrations et}

\item{mse}{Mean Squared Error of the model}

\item{clusters}{Number of partitions to create for local calibration. Centroids calculated by k-means method.
Default set to 6.}

\item{p_neighbours}{Proportion of xcal to localize neighboors in the KNN method. Default is 0.2.}

\item{PIT}{function to return the PIT-values. Default set to PIT_global() from this package.}
}
\value{
A tibble with five containing in the first column containing unique names for the partition, "y_cal",
the second column containing the yhat the third the pit-values  and the last the number of neighbors in each partition.
}
\description{
Return local PIT-values. Centroids for localization is obtained by k-means method from stats package.
The vicinity of such centroids are selected though a aproximate k-nearst neighboors method from RANN package.
}
\examples{

n <- 10000
split <- 0.8

mu <- function(x1){
10 + 5*x1^2
}

sigma_v <- function(x1){
 30*x1
}

x <- runif(n, 1, 10)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*split)]
y_train <- y[1:(n*split)]

x_cal <- x[(n*split+1):n]
y_cal <- y[(n*split+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

PIT_local(xcal = x_cal, ycal=y_cal, yhat=y_hat, mse=MSE_cal)

}
