% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_PIT_global.R
\name{gg_PIT_global}
\alias{gg_PIT_global}
\title{Plots Density Distributions of PIT-values for global calibration diagnose.}
\usage{
gg_PIT_global(
  pit,
  type = "density",
  fill = "steelblue4",
  alpha = 0.8,
  print_p = TRUE
)
}
\arguments{
\item{pit}{vector of pit values}

\item{type}{either "density" or "histogram" to change type of graph.}

\item{fill}{The color to fill the density plot. The default is 'stealblue4.}

\item{alpha}{The opacity of the density plot filling. Default is set to 0.8.}

\item{print_p}{Logical value indicating whether or not to print the p-value of ks.test()}
}
\value{
a ggplot density graph
}
\description{
A function based on ggplot2 to observe the global the density of PIT-values.
For more detailed edition of layers a posteriori, please refer to ggplot2 User Guide.
}
\examples{

n <- 10000
split <- 0.8

# generating heterocedastic data
mu <- function(x1){
10 + 5*x1^2
}

sigma_v <- function(x1){
30*x1
}

x <- runif(n, 1, 10)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*split)]
y_train <- y[1:(n*split)]

x_cal <- x[(n*split+1):n]
y_cal <- y[(n*split+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

pit <- PIT_global(ycal=y_cal, yhat=y_hat, mse=MSE_cal)

gg_PIT_global(pit)




}
