% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{literal}
\alias{literal}
\title{Treat part of a regular expression literally.}
\usage{
literal(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Treats its contents as literal characters.
}
\examples{
(rx <- digit(1, 3))
(rx_literal <- literal(rx))

# Usage
stringi::stri_detect_regex("123", rx)
stringi::stri_detect_regex("123", rx_literal)
stringi::stri_detect_regex("[[:digit:]]{1,3}", rx_literal)
}

