library(rearrr)
context("create_origin_fn()")


test_that("create_origin_fn()", {

  # Create an origin function
  median_origin_fn <- create_origin_fn(median)

  ## Testing 'median_origin_fn(c(1,2,3), c(9,8,6,3), c(42,...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- median_origin_fn(c(1,2,3), c(9,8,6,3), c(42,6,3,1))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 7, 4.5),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'median_origin_fn(c(1,2,3), c(9,8,6,3), c(42,...'     ####


  # We can't check function definitions when running covr::*
  if (requireNamespace("covr", quietly = TRUE))
    testthat::skip_if(covr::in_covr())

  ## Testing 'median_origin_fn'                                             ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing is function
  expect_true(
    is.function(median_origin_fn))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(median_origin_fn),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(median_origin_fn),
    c("function (...) ", "{", "    list(...) %>% purrr::map(.f = function(x) {",
      "        rlang::exec(.fn = fn, x, !!!args)", "    }) %>% unlist(recursive = TRUE, use.names = FALSE)",
      "}"),
    fixed = TRUE)
  ## Finished testing 'median_origin_fn'                                    ####

})

test_that("centroid()", {

  ## Testing 'centroid(c(1,2,3), c(9,8,6,3), c(42,6,3,1))'                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- centroid(c(1,2,3), c(9,8,6,3), c(42,6,3,1))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 6.5, 13),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'centroid(c(1,2,3), c(9,8,6,3), c(42,6,3,1))'         ####

  # Set seed
  xpectr::set_test_seed(1)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # Find centroid for each vector

  ## Testing 'centroid(x, y, z)'                                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14820 <- centroid(x, y, z)
  # Testing class
  expect_equal(
    class(output_14820),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14820,
    type = "double")
  # Testing values
  expect_equal(
    output_14820,
    c(0.55151, 0.55882, 0.41832),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_14820),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14820),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14820)),
    3L)
  ## Finished testing 'centroid(x, y, z)'                                   ####


  ## Testing 'centroid(x, y, z, cols = c("x", "y", "z"))'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(centroid(x, y, z, cols = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("'cols' should only be specified when '...' contains a single data.frame."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'centroid(x, y, z, cols = c("x", "y", "z"))'          ####

  df <- data.frame(
    "x" = x,
    "y" = y,
    "z" = z,
    "g" = rep(1:2, each = 5)
  )

  # Find centroid

  ## Testing 'centroid(df, cols = c("x", "y", "z"))'                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- centroid(df, cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    0.55151,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    0.55882,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    0.41832,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(1L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'centroid(df, cols = c("x", "y", "z"))'               ####


  # When 'df' is grouped

  ## Testing 'df %>% dplyr::group_by(g) %>% centroid(cols ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- df %>%
      dplyr::group_by(g) %>%
      centroid(cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["g"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0.46408, 0.63895),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.4447, 0.67294),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.43826, 0.39839),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("g", "x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df %>% dplyr::group_by(g) %>% centroid(cols ...'     ####


})

test_that("most_centered()", {
  xpectr::set_test_seed(42)

  ## Testing 'most_centered(c(1,2,3), c(9,8,6), c(6,3,1))'                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- most_centered(c(1,2,3), c(9,8,6), c(6,3,1))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 8, 3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'most_centered(c(1,2,3), c(9,8,6), c(6,3,1))'         ####


  ## Testing 'most_centered(c(1,2,3), c(9,8,6,3), c(42,6,3...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(c(1,2,3), c(9,8,6,3), c(42,6,3,1)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * all vectors in '...' must have the same length."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(c(1,2,3), c(9,8,6,3), c(42,6,3...'     ####


  ## Testing 'most_centered(list(c(1,2,3), c(9,8,6), c(42,...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(list(c(1,2,3), c(9,8,6), c(42,6,3))), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'list(...)': May only contain the following types: {numeric}, but element 1 has type 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(list(c(1,2,3), c(9,8,6), c(42,...'     ####


  # Test NAs


  ## Testing 'most_centered(c(1, 2, 3), c(9, 8, NA_real_),...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(c(1, 2, 3), c(9, 8, NA_real_), c(42, 6, 3)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * '...' contained missing values ('NA's)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(c(1, 2, 3), c(9, 8, NA_real_),...'     ####


  ## Testing 'most_centered(c(1, 2, 3), c(9, 8, NA_real_),...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- most_centered(c(1, 2, 3), c(9, 8, NA_real_), c(42, 6, 3), na.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 8, 6),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'most_centered(c(1, 2, 3), c(9, 8, NA_real_),...'     ####


  ## Testing 'most_centered(c(1, 2, 3), c(NA_real_, NA_rea...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(c(1, 2, 3), c(NA_real_, NA_real_, NA_real_), c(42, 6, 3), na.rm = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * After removing missing values ('NA's), there were no data points left."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(c(1, 2, 3), c(NA_real_, NA_rea...'     ####


  ## Examples
  xpectr::set_test_seed(1)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # Find coordinates of the data point
  # closest to the centroid

  ## Testing 'most_centered(x, y, z)'                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14820 <- most_centered(x, y, z)
  # Testing class
  expect_equal(
    class(output_14820),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14820,
    type = "double")
  # Testing values
  expect_equal(
    output_14820,
    c(0.57285, 0.68702, 0.65167),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_14820),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14820),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14820)),
    3L)
  ## Finished testing 'most_centered(x, y, z)'                              ####


  ## Testing 'most_centered(x, y, z, cols = c("a", "b"))'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(x, y, z, cols = c("a", "b")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("'cols' should only be specified when '...' contains a single data.frame."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(x, y, z, cols = c("a", "b"))'          ####


  df <- data.frame(
    "x" = x,
    "y" = y,
    "z" = z,
    "g" = rep(1:2, each = 5)
  )


  ## Testing 'most_centered(df, cols = c("x", "y", "z"))'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- most_centered(df, cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    0.57285,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    0.68702,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    0.65167,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(1L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'most_centered(df, cols = c("x", "y", "z"))'          ####



  ## Testing 'most_centered(df, cols = c("x", "y", NA))'                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(most_centered(df, cols = c("x", "y", NA)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Contains missing values (element 3)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'most_centered(df, cols = c("x", "y", NA))'           ####


  ## Testing 'df %>% dplyr::group_by(g) %>% most_centered(...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- df %>%
      dplyr::group_by(g) %>%
      most_centered(cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["g"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0.57285, 0.89839),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.68702, 0.4977),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.65167, 0.38611),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("g", "x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df %>% dplyr::group_by(g) %>% most_centered(...'     ####


})

test_that("midrange()", {
  xpectr::set_test_seed(42)


  ## Testing 'midrange(c(1,2,3), c(4,6,8), c(100, 1000))'                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_10155 <- midrange(c(1,2,3), c(4,6,8), c(100, 1000))
  # Testing class
  expect_equal(
    class(output_10155),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10155,
    type = "double")
  # Testing values
  expect_equal(
    output_10155,
    c(2, 6, 550),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_10155),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10155),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10155)),
    3L)
  ## Finished testing 'midrange(c(1,2,3), c(4,6,8), c(100, 1000))'          ####


  ## Testing 'midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000), na.rm = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 6, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000...'     ####


  ## Testing 'midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000), na.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(2, 6, 550),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'midrange(c(1,2,3), c(4,6,8), c(100, NA, 1000...'     ####


  ## Testing 'midrange(c(1,2,3), c(4,6,8), c(100, 1000), c...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(midrange(c(1,2,3), c(4,6,8), c(100, 1000), cols = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("'cols' should only be specified when '...' contains a single data.frame."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'midrange(c(1,2,3), c(4,6,8), c(100, 1000), c...'     ####



  ## Examples

  xpectr::set_test_seed(42)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # Find midrange for each vector

  ## Testing 'midrange(x, y, z)'                                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- midrange(x, y, z)
  # Testing class
  expect_equal(
    class(output_17375),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "double")
  # Testing values
  expect_equal(
    output_17375,
    c(0.53587, 0.54786, 0.53566),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    3L)
  ## Finished testing 'midrange(x, y, z)'                                   ####

  df <- data.frame(
    "x" = x,
    "y" = y,
    "z" = z,
    "g" = rep(1:2, each = 5)
  )


  ## Testing 'midrange(df, cols = c("x", "y", "z"))'                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- midrange(df, cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    0.53587,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    0.54786,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    0.53566,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(1L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'midrange(df, cols = c("x", "y", "z"))'               ####


  ## Testing 'df %>% dplyr::group_by(g) %>% midrange(cols ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- df %>%
      dplyr::group_by(g) %>%
      midrange(cols = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["g"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0.61161, 0.43563),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.59505, 0.54786),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.53566, 0.64797),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("g", "x", "y", "z"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df %>% dplyr::group_by(g) %>% midrange(cols ...'     ####


})

test_that("is_most_centered()", {
  xpectr::set_test_seed(42)


  ## Testing 'is_most_centered(c(1,2,3), c(9,8,6), c(6,3,1))'               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14820 <- is_most_centered(c(1,2,3), c(9,8,6), c(6,3,1))
  # Testing class
  expect_equal(
    class(output_14820),
    "logical",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14820,
    type = "logical")
  # Testing values
  expect_equal(
    output_14820,
    c(FALSE, TRUE, FALSE))
  # Testing names
  expect_equal(
    names(output_14820),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14820),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14820)),
    3L)
  ## Finished testing 'is_most_centered(c(1,2,3), c(9,8,6), c(6,3,1))'      ####


  ## Testing 'is_most_centered(c(1,2,3), c(9,8,6,3), c(42,...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(is_most_centered(c(1,2,3), c(9,8,6,3), c(42,6,3,1)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * all vectors in '...' must have the same length."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'is_most_centered(c(1,2,3), c(9,8,6,3), c(42,...'     ####


  ## Testing 'is_most_centered(list(c(1,2,3), c(9,8,6), c(...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(is_most_centered(list(c(1,2,3), c(9,8,6), c(42,6,3))), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("Assertion on 'list(...)' failed: May only contain the following types: {numeric}, but element 1 has type 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'is_most_centered(list(c(1,2,3), c(9,8,6), c(...'     ####


  ## Examples
  xpectr::set_test_seed(1)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # Find the data point
  # closest to the centroid


  ## Testing 'is_most_centered(x, y, z)'                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14820 <- is_most_centered(x, y, z)
  # Testing class
  expect_equal(
    class(output_14820),
    "logical",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14820,
    type = "logical")
  # Testing values
  expect_equal(
    output_14820,
    c(FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
      FALSE))
  # Testing names
  expect_equal(
    names(output_14820),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14820),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14820)),
    10L)
  ## Finished testing 'is_most_centered(x, y, z)'                           ####



  ## Testing 'is_most_centered(c(1,2,3))'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- is_most_centered(c(1, 2, 3))
  # Testing class
  expect_equal(
    class(output_19148),
    "logical",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "logical")
  # Testing values
  expect_equal(
    output_19148,
    c(FALSE, TRUE, FALSE))
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'is_most_centered(c(1,2,3))'                          ####


  ## Testing 'is_most_centered(c(1,2,3), c(NA_real_, NA_re...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(is_most_centered(c(1,2,3), c(NA_real_, NA_real_, 1), na.rm = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * '...' contained missing values ('NA's)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'is_most_centered(c(1,2,3), c(NA_real_, NA_re...'     ####


  ## Testing 'is_most_centered(c(1,2,3), c(NA_real_, NA_re...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- is_most_centered(c(1,2,3), c(NA_real_, NA_real_, 1), na.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "logical",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "logical")
  # Testing values
  expect_equal(
    output_19148,
    c(FALSE, FALSE, TRUE))
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'is_most_centered(c(1,2,3), c(NA_real_, NA_re...'     ####


  # All data points contain NAs
  ## Testing 'is_most_centered(c(1,2,NA_real_), c(NA_real_...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(is_most_centered(c(1,2,NA_real_), c(NA_real_, NA_real_, 1), na.rm = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * After removing missing values ('NA's), there were no data points left."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'is_most_centered(c(1,2,NA_real_), c(NA_real_...'     ####


  df <- data.frame(
    "x" = x,
    "y" = y,
    "z" = z,
    "g" = rep(1:2, each = 5)
  )


  ## Testing 'is_most_centered(df, cols = c("x", "y", "z"))'                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(is_most_centered(df, cols = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("Assertion on 'list(...)' failed: May only contain the following types: {numeric}, but element 1 has type 'data.frame'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'is_most_centered(df, cols = c("x", "y", "z"))'       ####


  ## Testing 'df %>% dplyr::group_by(g) %>% dplyr::filter(...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- df %>%
      dplyr::group_by(g) %>%
      dplyr::filter(is_most_centered(x, y, z))
  # Testing class
  expect_equal(
    class(output_19148),
    c("grouped_df", "tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.57285, 0.89839),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.68702, 0.4977),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.65167, 0.38611),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    "g",
    fixed = TRUE)
  ## Finished testing 'df %>% dplyr::group_by(g) %>% dplyr::filter(...'     ####


})
