% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_clusters.R
\name{generate_clusters}
\alias{generate_clusters}
\title{Generate n-dimensional clusters}
\usage{
generate_clusters(
  num_rows,
  num_cols,
  num_clusters,
  compactness = 1.6,
  generator = runif,
  name_prefix = "D",
  cluster_col_name = ".cluster"
)
}
\arguments{
\item{num_rows}{Number of rows.}

\item{num_cols}{Number of columns (dimensions).}

\item{num_clusters}{Number of clusters.}

\item{compactness}{How compact the clusters should be. A larger value leads to more compact clusters (on average).

Technically, it is passed to the \code{`multiplier`} argument in
\code{\link[rearrr:cluster_groups]{cluster_groups()}} as \eqn{`0.1 / compactness`}.}

\item{generator}{Function to generate the numeric values.

Must have the \emph{number of values to generate} as its first (and only required) argument,
as that is the only argument we pass to it.}

\item{name_prefix}{Prefix string for naming columns.}

\item{cluster_col_name}{Name of cluster factor.}
}
\value{
\code{data.frame} (\code{tibble}) with the clustered columns and the cluster grouping factor.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Generates \code{data.frame} (\code{tibble}) with clustered groups.
}
\details{
\itemize{
\item{Generates \code{data.frame} with random values using the \code{`generator`}.}
\item{Divides the rows into groups (the clusters).}
\item{Contracts the distance from each data point to the centroid of its group.}
\item{Performs MinMax scaling such that the scale of the data points is similar to the generated data.}
}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)
library(ggplot2)
library(plotly)

# Set seed
set.seed(10)

# Generate clusters
generate_clusters(num_rows = 20, num_cols = 3, num_clusters = 3, compactness = 1.6)
generate_clusters(num_rows = 20, num_cols = 5, num_clusters = 6, compactness = 2.5)

# Generate clusters and plot them
# Tip: Call this multiple times
# to see the behavior of `generate_clusters()`
generate_clusters(
  num_rows = 50, num_cols = 2,
  num_clusters = 5, compactness = 1.6
) \%>\%
  ggplot(
    aes(x = D1, y = D2, color = .cluster)
  ) +
  geom_point() +
  theme_minimal() +
  labs(x = "D1", y = "D2", color = "Cluster")

#
# Plot clusters in 3d view
#

# Generate clusters
clusters <- generate_clusters(
  num_rows = 50, num_cols = 3,
  num_clusters = 5, compactness = 1.6
)

\dontrun{
# Plot 3d with plotly
plotly::plot_ly(
  x = clusters$D1,
  y = clusters$D2,
  z = clusters$D3,
  type = "scatter3d",
  mode = "markers",
  color = clusters$.cluster
)
}
}
\seealso{
Other clustering functions: 
\code{\link{cluster_groups}()},
\code{\link{transfer_centroids}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{clustering functions}
