library(rearrr)
context("formers")


test_that("hexagonalize()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "y" = runif(200),
    "g" = factor(rep(1:5, each = 40))
  )

  # Generate expectations for 'hexagonalize'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = hexagonalize,
  #   args_values = list(
  #     "data" = list(c(1:10), c(1,2, NA, 4), df, "hej"),
  #     "y_col" = list(NULL, "y"),
  #     ".min" = list(NULL, -2, 3, "hej", NA),
  #     ".max" = list(NULL, 12, 8, "hej", NA),
  #     "offset_x" = list(0, 4, "hej", NA),
  #     "keep_original" = list(FALSE, TRUE, NA, "hej"),
  #     "x_col_name" = list("x", ".hexagon_x", "", NA, 1),
  #     "edge_col_name" = list(".edge", NA, NULL),
  #     "overwrite" = list(TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = df, "y_col" = "y", "x_col_name" = ".hexa_x"),
  #     list("data" = dplyr::group_by(df, g), "y_col" = "y", "x_col_name" = ".hexa_x"),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "g", "overwrite" = FALSE),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "tjep", "edge_col_name" = "tjep")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'hexagonalize'                                                   ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0, 1.73205, -3.4641, 3.89711, -3.89711, 3.89711, -3.89711, 3.4641,
      -1.73205, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".edge"]],
    structure(c(4L, 3L, 4L, 2L, 5L, 2L, 5L, 1L, 6L, 1L), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1, 2, NA, 4), y_col = ...
  # Changed from baseline: data = c(1, 2, NA, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(hexagonalize(data = c(1, 2, NA, 4), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'double'\n * checkmate::check_vector(data): Contains missing values (element 3)\n * checkmate::check_factor(data): Must be of type 'factor', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = df, y_col = NULL, .min =...
  # Changed from baseline: data = df
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(hexagonalize(data = df, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = "hej", y_col = NULL, .mi...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(hexagonalize(data = "hej", y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''data' as vector': May only contain the following types: {numeric,factor}, but\n * element 1 has type 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = NULL, y_col = NULL, .min...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(hexagonalize(data = NULL, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = df, y_col = "y", .min = ...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- hexagonalize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".hexa_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_15190[["y"]], n = 30),
    c(0.46229, 0.13871, 0.08244, 0.51421, 0.63998, 0.67728, 0.82816,
      0.00788, 0.56365, 0.2337, 0.30522, 0.21716, 0.39497, 0.9192,
      0.85048, 0.57982, 0.46407, 0.18787, 0.60177, 0.19699, 0.31705,
      0.48031, 0.13649, 0.82468, 0.76903, 0.31698, 0.9179, 0.28775,
      0.12909, 0.07225),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15190[[".hexa_x"]], n = 30),
    c(-0.4281, 0.23984, -0.14237, 0.4281, -0.4281, -0.4281, -0.2784,
      -0.01324, 0.4281, 0.40437, -0.4281, 0.37571, -0.4281, 0.1207,
      0.23973, -0.4281, 0.4281, -0.32498, -0.4281, 0.34079, -0.4281,
      -0.4281, -0.23599, 0.28442, 0.38081, 0.4281, 0.12295, -0.4281,
      -0.22318, -0.12473),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_15190[[".edge"]], n = 30),
    structure(c(5L, 3L, 4L, 2L, 5L, 5L, 6L, 4L, 2L, 3L, 5L, 3L, 5L,
      1L, 1L, 5L, 2L, 4L, 5L, 3L, 5L, 5L, 4L, 1L, 1L, 2L, 1L, 5L,
      4L, 4L), .Label = c("1", "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_15190),
    c("y", ".hexa_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("numeric", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("double", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(200L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = dplyr::group_by(df, g), ...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- hexagonalize(data = dplyr::group_by(df, g), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".hexa_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_17365[["y"]], n = 30),
    c(0.46229, 0.13871, 0.08244, 0.51421, 0.63998, 0.67728, 0.82816,
      0.00788, 0.56365, 0.2337, 0.30522, 0.21716, 0.39497, 0.9192,
      0.85048, 0.57982, 0.46407, 0.18787, 0.60177, 0.19699, 0.31705,
      0.48031, 0.13649, 0.82468, 0.76903, 0.31698, 0.9179, 0.28775,
      0.12909, 0.07225),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[["g"]], n = 30),
    structure(c(1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 4L,
      4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    xpectr::smpl(output_17365[[".hexa_x"]], n = 30),
    c(0.42649, 0.23341, -0.13595, 0.42649, 0.42489, 0.42489, 0.26788,
      0.01094, -0.41672, 0.40437, -0.41672, -0.37571, 0.40421, -0.07511,
      -0.19414, 0.40421, 0.40421, 0.27502, 0.38178, 0.24918, 0.38178,
      -0.38178, 0.14439, 0.19077, 0.28716, -0.38178, 0.0293, 0.38178,
      0.13157, 0.03312),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_17365[[".edge"]], n = 30),
    structure(c(2L, 3L, 4L, 2L, 2L, 2L, 1L, 3L, 5L, 3L, 5L, 4L, 2L,
      6L, 6L, 2L, 2L, 3L, 2L, 3L, 2L, 5L, 3L, 1L, 1L, 5L, 1L, 2L,
      3L, 3L), .Label = c("1", "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17365),
    c("y", "g", ".hexa_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "factor", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(200L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = df, y_col = "y", .min = ...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(hexagonalize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "g", edge_col_name = ".edge", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = df, y_col = "y", .min = ...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(hexagonalize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "tjep", edge_col_name = "tjep", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"y\", \"tjep\", \"tjep\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = "y", .m...
  # Changed from baseline: y_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .min = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- hexagonalize(data = c(1:10), y_col = NULL, .min = -2, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["x"]],
    c(-5.19615, 5.19615, -5.19615, 5.19615, -5.19615, 5.19615, -5.19615,
      3.4641, -1.73205, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".edge"]],
    structure(c(3L, 2L, 4L, 2L, 4L, 2L, 5L, 1L, 5L, 1L), .Label = c("1",
      "2", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14577),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .min = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- hexagonalize(data = c(1:10), y_col = NULL, .min = 3, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["x"]],
    c(NA, NA, 0, 1.73205, -3.03109, 3.03109, -3.03109, 3.03109, -1.73205,
      0),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".edge"]],
    structure(c(NA, NA, 4L, 3L, 5L, 2L, 5L, 2L, 6L, 1L), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17191),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .min = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = "hej", .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NA, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .max = 8
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = 8, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["x"]],
    c(0, 1.73205, -3.03109, 3.03109, -3.03109, 3.03109, -1.73205, 0,
      NA, NA),
    tolerance = 1e-4)
  expect_equal(
    output_14622[[".edge"]],
    structure(c(4L, 3L, 5L, 2L, 5L, 2L, 6L, 1L, NA, NA), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14622),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .max = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = "hej", offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NA, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: .max = 12
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = 12, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["x"]],
    c(0, 1.73205, -3.4641, 4.76314, -4.76314, 4.76314, -4.76314, 4.76314,
      -4.76314, 3.4641),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".edge"]],
    structure(c(4L, 3L, 4L, 2L, 5L, 2L, 5L, 2L, 5L, 1L), .Label = c("1",
      "2", "3", "4", "5"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_11174),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: offset_x = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 4, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["x"]],
    c(4, 5.73205, 0.5359, 7.89711, 0.10289, 7.89711, 0.10289, 7.4641,
      2.26795, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".edge"]],
    structure(c(4L, 3L, 4L, 2L, 5L, 2L, 5L, 1L, 6L, 1L), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14749),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: offset_x = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = "hej", keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: offset_x = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NA, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: offset_x = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NULL, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = TRUE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["x"]],
    c(0, 1.73205, -3.4641, 3.89711, -3.89711, 3.89711, -3.89711, 3.4641,
      -1.73205, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".edge"]],
    structure(c(4L, 3L, 4L, 2L, 5L, 2L, 5L, 1L, 6L, 1L), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19888),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: keep_original = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NA, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: keep_original = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = "hej", x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NULL, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: x_col_name = ".hexago...
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".hexagon_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".hexagon_x"]],
    c(0, 1.73205, -3.4641, 3.89711, -3.89711, 3.89711, -3.89711, 3.4641,
      -1.73205, 0),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".edge"]],
    structure(c(4L, 3L, 4L, 2L, 5L, 2L, 5L, 1L, 6L, 1L), .Label = c("1",
      "2", "3", "4", "5", "6"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_13902),
    c("Value", ".hexagon_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: x_col_name = ""
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must have at least 1 characters."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: x_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NA, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: x_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = 1, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: x_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NULL, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: edge_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'edge_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: edge_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13881),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13881[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13881[["x"]],
    c(0, 1.73205, -3.4641, 3.89711, -3.89711, 3.89711, -3.89711, 3.4641,
      -1.73205, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13881),
    c("Value", "x"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13881),
    c("integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13881),
    c("integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13881),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13881)),
    character(0),
    fixed = TRUE)

  # Testing hexagonalize(data = c(1:10), y_col = NULL, ....
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(hexagonalize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'hexagonalize'                                          ####
  #
})

test_that("circularize()", {

  xpectr::set_test_seed(42)

  df <- data.frame(
    "y" = runif(30),
    "k" = 1:30,
    "g" = factor(rep(1:5, each = 6))
  )

  # Generate expectations for 'circularize'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = circularize,
  #   args_values = list(
  #     "data" = list(c(1:10), c(1, 2, NA, 4), df, "hej"),
  #     "y_col" = list(NULL, "y"),
  #     ".min" = list(NULL,-2, 3, "hej", NA),
  #     ".max" = list(NULL, 12, 8, "hej", NA),
  #     "offset_x" = list(0, 4, "hej", NA),
  #     "keep_original" = list(FALSE, TRUE, NA, "hej"),
  #     "x_col_name" = list("x", ".circle_x", "", NA, 1),
  #     "degrees_col_name" = list(".degrees", 1, NA),
  #     "origin_col_name" = list(".origin", NA, 1),
  #     "overwrite" = list(TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = df, "y_col" = "y", "x_col_name" = ".circ_x"),
  #     list("data" = dplyr::group_by(df, g), "y_col" = "y", "x_col_name" = ".circ_x"),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "g", "overwrite" = FALSE),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "tjep", "degrees_col_name" = "tjep")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'circularize'                                                    ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0, 2.82843, -3.74166, 4.24264, -4.47214, 4.47214, -4.24264, 3.74166,
      -2.82843, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".degrees"]],
    c(270, 308.94244, 213.74899, 340.52878, 186.37937, 6.37937, 160.52878,
      33.74899, 128.94244, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1, 2, NA, 4), y_col = N...
  # Changed from baseline: data = c(1, 2, NA, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(circularize(data = c(1, 2, NA, 4), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'double'\n * checkmate::check_vector(data): Contains missing values (element 3)\n * checkmate::check_factor(data): Must be of type 'factor', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = df, y_col = NULL, .min = ...
  # Changed from baseline: data = df
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(circularize(data = df, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = "hej", y_col = NULL, .min...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(circularize(data = "hej", y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''data' as vector': May only contain the following types: {numeric,factor}, but\n * element 1 has type 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = NULL, y_col = NULL, .min ...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(circularize(data = NULL, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = df, y_col = "y", .min = N...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- circularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circ_x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15190[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".circ_x"]],
    c(0.24833, 0.21044, 0.37835, 0.34426, -0.44064, -0.45292, -0.40626,
      -0.21122, 0.43669, -0.42038, -0.44648, 0.41444, -0.21496, -0.35621,
      0.44725, -0.20473, -0.09774, 0.17476, -0.44915, 0.45256, 0.26405,
      0.21873, 0, 0.19103, 0, 0.45272, -0.42925, -0.26165, 0.44446,
      -0.33943),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".degrees"]],
    c(56.77626, 62.33439, 326.5951, 40.57245, 166.46397, 182.09504,
      153.68423, 242.22223, 15.52729, 158.05204, 189.89999, 23.87601,
      118.31295, 218.19298, 350.68353, 116.8544, 102.45437, 292.68098,
      187.69252, 3.12002, 54.36689, 298.85544, 90, 65.07199, 270,
      357.28697, 198.72011, 125.26108, 348.71458, 138.49624),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15190),
    c("y", ".circ_x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(30L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = dplyr::group_by(df, g), y...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- circularize(data = dplyr::group_by(df, g), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circ_x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    output_17365[[".circ_x"]],
    c(-0.11832, 0, 0, 0.24091, -0.32407, 0.31204, 0, 0, -0.2039, 0.13409,
      0.30015, -0.10106, 0.18866, 0.31576, -0.42178, -0.17729, 0,
      0, 0.41571, -0.42508, 0.25484, 0, 0, -0.1847, 0, 0.41116, 0.39833,
      0, -0.40894, -0.22924),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".degrees"]],
    c(111.31795, 90, 270, 42.2515, 174.68685, 343.48648, 90, 270, 132.64824,
      63.54147, 4.21384, 109.62134, 64.00054, 317.19687, 191.46769,
      114.3267, 90, 270, 347.94177, 180.46747, 53.16557, 270, 90,
      115.75348, 270, 2.80208, 345.38275, 90, 186.57258, 123.83966),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("y", "g", ".circ_x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "factor", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(30L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = df, y_col = "y", .min = N...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(circularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "g", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = df, y_col = "y", .min = N...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(circularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "tjep", degrees_col_name = "tjep", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"y\", \"tjep\", \"tjep\", \".origin\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = "y", .mi...
  # Changed from baseline: y_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .min = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- circularize(data = c(1:10), y_col = NULL, .min = -2, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["x"]],
    c(-5.19615, 5.65685, -5.91608, 6, -5.91608, 5.65685, -5.19615, 4.47214,
      -3.31662, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".degrees"]],
    c(210, 340.52878, 189.59407, 0, 170.40593, 19.47122, 150, 41.81031,
      123.55731, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .min = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- circularize(data = c(1:10), y_col = NULL, .min = 3, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["x"]],
    c(NA, NA, 0, 2.44949, -3.16228, 3.4641, -3.4641, 3.16228, -2.44949,
      0),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".degrees"]],
    c(NA, NA, 270, 314.41531, 205.37693, 351.78679, 171.78679, 25.37693,
      134.41531, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .min = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = "hej", .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NA, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .max = 8
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = 8, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["x"]],
    c(0, 2.44949, -3.16228, 3.4641, -3.4641, 3.16228, -2.44949, 0, NA,
      NA),
    tolerance = 1e-4)
  expect_equal(
    output_14622[[".degrees"]],
    c(270, 314.41531, 205.37693, 351.78679, 171.78679, 25.37693, 134.41531,
      90, NA, NA),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14622),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .max = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = "hej", offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NA, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: .max = 12
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = 12, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["x"]],
    c(0, 3.16228, -4.24264, 4.89898, -5.2915, 5.47723, -5.47723, 5.2915,
      -4.89898, 4.24264),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".degrees"]],
    c(270, 305.0968, 219.5212, 332.96431, 195.82662, 354.78409, 174.78409,
      15.82662, 152.96431, 39.5212),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: offset_x = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 4, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["x"]],
    c(4, 6.82843, 0.25834, 8.24264, -0.47214, 8.47214, -0.24264, 7.74166,
      1.17157, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".degrees"]],
    c(270, 308.94244, 213.74899, 340.52878, 186.37937, 6.37937, 160.52878,
      33.74899, 128.94244, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14749),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: offset_x = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = "hej", keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: offset_x = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NA, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: offset_x = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NULL, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = TRUE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["x"]],
    c(0, 2.82843, -3.74166, 4.24264, -4.47214, 4.47214, -4.24264, 3.74166,
      -2.82843, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".degrees"]],
    c(270, 308.94244, 213.74899, 340.52878, 186.37937, 6.37937, 160.52878,
      33.74899, 128.94244, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19888),
    c("Value", "x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: keep_original = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NA, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: keep_original = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = "hej", x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NULL, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: x_col_name = ".circle_x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circle_x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".circle_x"]],
    c(0, 2.82843, -3.74166, 4.24264, -4.47214, 4.47214, -4.24264, 3.74166,
      -2.82843, 0),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".degrees"]],
    c(270, 308.94244, 213.74899, 340.52878, 186.37937, 6.37937, 160.52878,
      33.74899, 128.94244, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13902),
    c("Value", ".circle_x", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: x_col_name = ""
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must have at least 1 characters."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: x_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NA, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: x_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = 1, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: x_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: degrees_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = 1, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees_col_name': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: degrees_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = NA, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_16851 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16851),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16851[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_16851[["x"]],
    c(0, 2.82843, -3.74166, 4.24264, -4.47214, 4.47214, -4.24264, 3.74166,
      -2.82843, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16851),
    c("Value", "x", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16851),
    c("integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16851),
    c("integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16851),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16851)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: origin_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: origin_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = 1, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_10073 <- circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10073),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10073[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_10073[["x"]],
    c(0, 2.82843, -3.74166, 4.24264, -4.47214, 4.47214, -4.24264, 3.74166,
      -2.82843, 0),
    tolerance = 1e-4)
  expect_equal(
    output_10073[[".degrees"]],
    c(270, 308.94244, 213.74899, 340.52878, 186.37937, 6.37937, 160.52878,
      33.74899, 128.94244, 90),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10073),
    c("Value", "x", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10073),
    c("integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10073),
    c("integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10073),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10073)),
    character(0),
    fixed = TRUE)

  # Testing circularize(data = c(1:10), y_col = NULL, .m...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(circularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'circularize'                                           ####
  #

})

test_that("triangularize()", {

  xpectr::set_test_seed(42)

  df <- data.frame(
    "y" = runif(30),
    "k" = 1:30,
    "g" = factor(rep(1:5, each = 6))
  )


  # Generate expectations for 'triangularize'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = triangularize,
  #   args_values = list(
  #     "data" = list(c(1:10), c(1, 2, NA, 4), df, "hej"),
  #     "y_col" = list(NULL, "y"),
  #     ".min" = list(NULL, -2, 3, "hej", NA),
  #     ".max" = list(NULL, 12, 8, "hej", NA),
  #     "offset_x" = list(0, 4, "hej", NA),
  #     "keep_original" = list(FALSE, TRUE, NA, "hej"),
  #     "x_col_name" = list("x", ".circle_x", "", NA, 1),
  #     "edge_col_name" = list(".edge", NA),
  #     "overwrite" = list(TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = df, "y_col" = "y", "x_col_name" = ".circ_x"),
  #     list("data" = dplyr::group_by(df, g), "y_col" = "y", "x_col_name" = ".circ_x"),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "g", "overwrite" = FALSE),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "tjep", "edge_col_name" = "tjep")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'triangularize'                                                  ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0, 0, 2, 3, 4, 0, 3, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 2L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1, 2, NA, 4), y_col =...
  # Changed from baseline: data = c(1, 2, NA, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(triangularize(data = c(1, 2, NA, 4), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'double'\n * checkmate::check_vector(data): Contains missing values (element 3)\n * checkmate::check_factor(data): Must be of type 'factor', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = df, y_col = NULL, .min ...
  # Changed from baseline: data = df
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(triangularize(data = df, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = "hej", y_col = NULL, .m...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(triangularize(data = "hej", y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''data' as vector': May only contain the following types: {numeric,factor}, but\n * element 1 has type 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = NULL, y_col = NULL, .mi...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(triangularize(data = NULL, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = df, y_col = "y", .min =...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- triangularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circ_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15190[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".circ_x"]],
    c(0, 0, 0, 0, 0.34715, 0, 0.2523, 0.05223, 0, 0.28383, 0.3753, 0,
      0.05422, 0.17299, 0, 0.04888, 0.01067, 0, 0, 0, 0.08486, 0.05627,
      0, 0, 0, 0.43177, 0.30777, 0.08315, 0, 0.15289),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".edge"]],
    structure(c(3L, 3L, 3L, 3L, 1L, 3L, 1L, 2L, 3L, 1L, 2L, 3L, 1L,
      2L, 3L, 1L, 1L, 3L, 3L, 3L, 1L, 2L, 1L, 3L, 3L, 2L, 2L, 1L,
      3L, 1L), .Label = c("1", "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_15190),
    c("y", ".circ_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("numeric", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("double", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(30L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = dplyr::group_by(df, g),...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- triangularize(data = dplyr::group_by(df, g), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circ_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    output_17365[[".circ_x"]],
    c(0.02227, 0, 0, 0.10663, 0.29533, 0, 0, 0, 0.0796, 0, 0.27885,
      0.01748, 0.04355, 0, 0.34481, 0.03821, 0, 0, 0.33629, 0.42162,
      0.08486, 0, 0, 0, 0, 0.39153, 0, 0, 0.36453, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".edge"]],
    structure(c(1L, 3L, 2L, 1L, 1L, 3L, 1L, 3L, 1L, 3L, 1L, 1L, 1L,
      3L, 2L, 1L, 3L, 2L, 2L, 2L, 1L, 3L, 1L, 3L, 2L, 1L, 3L, 1L,
      2L, 3L), .Label = c("1", "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17365),
    c("y", "g", ".circ_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "factor", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(30L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = df, y_col = "y", .min =...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(triangularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "g", edge_col_name = ".edge", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = df, y_col = "y", .min =...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(triangularize(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "tjep", edge_col_name = "tjep", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"y\", \"tjep\", \"tjep\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = "y", ....
  # Changed from baseline: y_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .min = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- triangularize(data = c(1:10), y_col = NULL, .min = -2, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["x"]],
    c(0, 0, 5, 6, 5, 0, 3, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".edge"]],
    structure(c(3L, 3L, 2L, 1L, 1L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14577),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .min = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- triangularize(data = c(1:10), y_col = NULL, .min = 3, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["x"]],
    c(NA, NA, 0, 0, 2, 3, 3, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".edge"]],
    structure(c(NA, NA, 3L, 3L, 2L, 2L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17191),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .min = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = "hej", .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NA, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .max = 8
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = 8, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["x"]],
    c(0, 0, 2, 3, 3, 0, 1, 0, NA, NA),
    tolerance = 1e-4)
  expect_equal(
    output_14622[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 1L, 3L, 1L, 3L, NA, NA), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14622),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .max = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = "hej", offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NA, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: .max = 12
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = 12, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["x"]],
    c(0, 0, 2, 3, 4, 0, 5, 0, 3, 0),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 2L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_11174),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: offset_x = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 4, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["x"]],
    c(4, 4, 6, 7, 8, 4, 7, 4, 5, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 2L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14749),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: offset_x = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = "hej", keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: offset_x = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NA, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: offset_x = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NULL, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = TRUE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["x"]],
    c(0, 0, 2, 3, 4, 0, 3, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 2L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19888),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: keep_original = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NA, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: keep_original = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = "hej", x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NULL, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: x_col_name = ".circle_x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".circle_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".circle_x"]],
    c(0, 0, 2, 3, 4, 0, 3, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".edge"]],
    structure(c(3L, 3L, 2L, 2L, 2L, 3L, 1L, 3L, 1L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_13902),
    c("Value", ".circle_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: x_col_name = ""
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must have at least 1 characters."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: x_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NA, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: x_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = 1, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: x_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NULL, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: edge_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'edge_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: edge_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13881),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13881[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13881[["x"]],
    c(0, 0, 2, 3, 4, 0, 3, 0, 1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13881),
    c("Value", "x"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13881),
    c("integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13881),
    c("integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13881),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13881)),
    character(0),
    fixed = TRUE)

  # Testing triangularize(data = c(1:10), y_col = NULL, ...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(triangularize(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'triangularize'                                         ####
  #

})

test_that("square()", {

  xpectr::set_test_seed(42)

  df <- data.frame(
    "y" = runif(30),
    "k" = 1:30,
    "g" = factor(rep(1:5, each = 6))
  )


  # Generate expectations for 'square'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = square,
  #   args_values = list(
  #     "data" = list(c(1:10), c(1, 2, NA, 4), df, "hej"),
  #     "y_col" = list(NULL, "y"),
  #     ".min" = list(NULL, -2, 3, "hej", NA),
  #     ".max" = list(NULL, 12, 8, "hej", NA),
  #     "offset_x" = list(0, 4, "hej", NA),
  #     "keep_original" = list(FALSE, TRUE, NA, "hej"),
  #     "x_col_name" = list("x", ".square_x", "", NA, 1),
  #     "edge_col_name" = list(".edge", NA),
  #     "overwrite" = list(TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = df, "y_col" = "y", "x_col_name" = ".squarsquar_x"),
  #     list("data" = dplyr::group_by(df, g), "y_col" = "y", "x_col_name" = ".square_x", "keep_original" = TRUE),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "g", "overwrite" = FALSE),
  #     list("data" = df, "y_col" = "y", "x_col_name" = "tjep", "edge_col_name" = "tjep")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'square'                                                         ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["x"]],
    c(0, 1, -2, 3, -4, 4, -3, 2, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 3L, 1L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1, 2, NA, 4), y_col = NULL, ...
  # Changed from baseline: data = c(1, 2, NA, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(square(data = c(1, 2, NA, 4), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'double'\n * checkmate::check_vector(data): Contains missing values (element 3)\n * checkmate::check_factor(data): Must be of type 'factor', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = df, y_col = NULL, .min = NULL,...
  # Changed from baseline: data = df
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(square(data = df, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = "hej", y_col = NULL, .min = NU...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(square(data = "hej", y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''data' as vector': May only contain the following types: {numeric,factor}, but element 1 has type\n * 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = NULL, y_col = NULL, .min = NUL...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(square(data = NULL, y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = df, y_col = "y", .min = NULL, ...
  # Changed from baseline: data, y_col, x_col_name
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- square(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".squarsquar_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15190[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".squarsquar_x"]],
    c(0.07409, 0.05182, 0.2037, 0.15844, -0.34715, -0.43666, -0.2523,
      -0.05223, 0.3319, -0.28383, -0.3753, 0.26978, -0.05422, -0.17299,
      0.37986, -0.04888, -0.01067, 0.03505, -0.39256, 0.42856, 0.08486,
      0.05627, 0, 0.04222, 0, 0.43177, -0.30777, -0.08315, 0.36453,
      -0.15289),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".edge"]],
    structure(c(1L, 1L, 2L, 1L, 4L, 3L, 4L, 3L, 1L, 4L, 3L, 1L, 4L,
      3L, 2L, 4L, 4L, 2L, 3L, 1L, 1L, 2L, 1L, 1L, 3L, 2L, 3L, 4L,
      2L, 4L), .Label = c("1", "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_15190),
    c("y", ".squarsquar_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("numeric", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("double", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(30L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing square(data = dplyr::group_by(df, g), y_col ...
  # Changed from baseline: data, y_col, keep_ori...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- square(data = dplyr::group_by(df, g), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = TRUE, x_col_name = ".square_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["y"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403,
      0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574,
      0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["k"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L,
      5L, 5L), .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    output_17365[[".square_x"]],
    c(-0.02227, 0, 0, 0.10663, -0.29533, 0.23296, 0, 0, -0.0796, 0.03152,
      0.27885, -0.01748, 0.04355, 0.13794, -0.34481, -0.03821, 0,
      0, 0.33629, -0.42162, 0.08486, 0, 0, -0.04222, 0, 0.39153, 0.30777,
      0, -0.36453, -0.06973),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".edge"]],
    structure(c(4L, 1L, 3L, 1L, 4L, 2L, 1L, 3L, 4L, 1L, 1L, 4L, 1L,
      2L, 3L, 4L, 1L, 3L, 2L, 3L, 1L, 3L, 1L, 4L, 3L, 1L, 2L, 1L,
      3L, 4L), .Label = c("1", "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17365),
    c("y", "k", "g", ".square_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "integer", "factor", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(30L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing square(data = df, y_col = "y", .min = NULL, ...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(square(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "g", edge_col_name = ".edge", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = df, y_col = "y", .min = NULL, ...
  # Changed from baseline: data, y_col, x_col_na...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(square(data = df, y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "tjep", edge_col_name = "tjep", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"y\", \"tjep\", \"tjep\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = "y", .min = N...
  # Changed from baseline: y_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = "y", .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .min = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- square(data = c(1:10), y_col = NULL, .min = -2, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["x"]],
    c(-3, 4, -5, 6, -5, 4, -3, 2, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".edge"]],
    structure(c(3L, 2L, 3L, 1L, 4L, 1L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14577),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .min = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- square(data = c(1:10), y_col = NULL, .min = 3, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["x"]],
    c(NA, NA, 0, 1, -2, 3, -3, 2, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".edge"]],
    structure(c(NA, NA, 3L, 2L, 3L, 2L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17191),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .min = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = "hej", .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NA, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .max = 8
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = 8, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14622),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14622[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14622[["x"]],
    c(0, 1, -2, 3, -3, 2, -1, 0, NA, NA),
    tolerance = 1e-4)
  expect_equal(
    output_14622[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 4L, 1L, 4L, 1L, NA, NA), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14622),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14622),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14622),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14622)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .max = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = "hej", offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NA, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: .max = 12
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = 12, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["x"]],
    c(0, 1, -2, 3, -4, 5, -5, 4, -3, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 3L, 2L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_11174),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: offset_x = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 4, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["x"]],
    c(4, 5, 2, 7, 0, 8, 1, 6, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 3L, 1L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_14749),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: offset_x = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = "hej", keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: offset_x = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NA, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: offset_x = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = NULL, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'offset_x': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = TRUE, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["x"]],
    c(0, 1, -2, 3, -4, 4, -3, 2, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 3L, 1L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19888),
    c("Value", "x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: keep_original = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NA, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: keep_original = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = "hej", x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = NULL, x_col_name = "x", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: x_col_name = ".square_x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = ".square_x", edge_col_name = ".edge", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".square_x"]],
    c(0, 1, -2, 3, -4, 4, -3, 2, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".edge"]],
    structure(c(3L, 2L, 3L, 2L, 3L, 1L, 4L, 1L, 4L, 1L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_13902),
    c("Value", ".square_x", ".edge"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("integer", "numeric", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(10L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: x_col_name = ""
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "", edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must have at least 1 characters."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: x_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NA, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: x_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = 1, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: x_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = NULL, edge_col_name = ".edge", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: edge_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'edge_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: edge_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13881),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13881[["Value"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_13881[["x"]],
    c(0, 1, -2, 3, -4, 4, -3, 2, -1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13881),
    c("Value", "x"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13881),
    c("integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13881),
    c("integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13881),
    c(10L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13881)),
    character(0),
    fixed = TRUE)

  # Testing square(data = c(1:10), y_col = NULL, .min = ...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(square(data = c(1:10), y_col = NULL, .min = NULL, .max = NULL, offset_x = 0, keep_original = FALSE, x_col_name = "x", edge_col_name = ".edge", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'square'                                                ####
  #
})
