% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexis.R
\name{get_nexis_html}
\alias{get_nexis_html}
\title{extract texts and meta data from Nexis HTML files}
\usage{
get_nexis_html(path, paragraph_separator = "\\n\\n", verbosity, ...)
}
\arguments{
\item{path}{either path to a HTML file or a directory that contains HTML
files}

\item{paragraph_separator}{a character to separate paragraphs in body texts}

\item{verbosity}{\itemize{
\item 0: output errors only
\item 1: output errors and warnings (default)
\item 2: output a brief summary message
\item 3: output detailed file-related messages
}}

\item{...}{only to trap extra arguments}
}
\description{
This extract headings, body texts and meta data (date, byline, length,
section, edition) from items in HTML files downloaded by the scraper.
}
\examples{
\dontrun{
irt <- readtext:::get_nexis_html('tests/data/nexis/irish-times_1995-06-12_0001.html')
afp <- readtext:::get_nexis_html('tests/data/nexis/afp_2013-03-12_0501.html')
gur <- readtext:::get_nexis_html('tests/data/nexis/guardian_1986-01-01_0001.html')
sun <- readtext:::get_nexis_html('tests/data/nexis/sun_2000-11-01_0001.html')
spg <- readtext:::get_nexis_html('tests/data/nexis/spiegel_2012-02-01_0001.html', 
                                  language_date = 'german')

all <- readtext('tests/data/nexis', source = 'nexis')
all <- readtext('tests/data/nexis', source = 'nexis')
}
}
\keyword{internal}
