% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcal.R
\name{stbcal}
\alias{stbcal}
\title{Parse Stata business calendar files}
\usage{
stbcal(stbcalfile)
}
\arguments{
\item{stbcalfile}{\emph{stbcal-file} Stata buisness calendar file created by
Stata.}
}
\value{
Returns a data.frame with two cols:
\describe{
\item{range:}{The date matching the buisnesdate. Date format.}
\item{buisdays:}{The Stata business calendar day. Integer format.}
}
}
\description{
Create conversion table for business calendar dates.
}
\details{
Stata 12 introduced business calender format. Business dates are
integer numbers in a certain range of days, weeks, months or years. In this
range some days are omitted (e.g. weekends or holidays). If a business
calendar was created, a stbcal file matching this calendar was created. This
file is required to read the business calendar. This parser reads the stbcal-
file and returns a data.frame with dates matching business calendar dates.

A dta-file containing Stata business dates imported with read.stata13() shows
in formats which stdcal file is required (e.g. "%tbsp500" requires
sp500.stbcal).

Stata allows adding a short description called purpose. This is added as an
attribute of the resulting data.frame.
}
\examples{
sp500 <- stbcal(system.file("extdata/sp500.stbcal", package="readstata13"))
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}

