% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{parse_factor}
\alias{parse_factor}
\alias{col_factor}
\title{Parse factors}
\usage{
parse_factor(
  x,
  levels = NULL,
  ordered = FALSE,
  na = c("", "NA"),
  locale = default_locale(),
  include_na = TRUE,
  trim_ws = TRUE
)

col_factor(levels = NULL, ordered = FALSE, include_na = FALSE)
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{levels}{Character vector providing set of allowed levels. if \code{NULL},
will generate levels based on the unique values of \code{x}, ordered by order
of appearance in \code{x}.}

\item{ordered}{Is it an ordered factor?}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{include_na}{If \code{NA} are present, include as an explicit factor to level?}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}
}
\description{
\code{parse_factor} is similar to \code{\link[=factor]{factor()}}, but will generate
warnings if elements of \code{x} are not found in \code{levels}.
}
\examples{
parse_factor(c("a", "b"), letters)

x <- c("cat", "dog", "caw")
levels <- c("cat", "dog", "cow")

# Base R factor() silently converts unknown levels to NA
x1 <- factor(x, levels)

# parse_factor generates a warning & problems
x2 <- parse_factor(x, levels)

# Using an argument of `NULL` will generate levels based on values of `x`
x2 <- parse_factor(x, levels = NULL)
}
\seealso{
Other parsers: 
\code{\link{col_skip}()},
\code{\link{cols_condense}()},
\code{\link{cols}()},
\code{\link{parse_datetime}()},
\code{\link{parse_guess}()},
\code{\link{parse_logical}()},
\code{\link{parse_number}()},
\code{\link{parse_vector}()}
}
\concept{parsers}
