% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_apra.R
\name{read_apra}
\alias{read_apra}
\title{Read APRA's Statistical Publications}
\usage{
read_apra(
  stat_pub,
  cur_hist = "current",
  path = tempdir(),
  quiet = FALSE,
  overwrite = TRUE,
  ...
)
}
\arguments{
\item{stat_pub}{character vector detailing a statistical publication to be
downloaded and imported. Must match a valid value in the
\code{apra_stat_pubs_acronym} variable of the \link{apra_stat_pubs} dataset.}

\item{cur_hist}{character vector detailing whether to download and import
a current or historic statistical publication. Must match a
valid value in the \code{cur_hist} variable of the \link{apra_stat_pubs}
dataset.}

\item{path}{path to where the downloaded file should be saved. Uses
\code{\link[base:tempfile]{base::tempdir()}} by default.}

\item{quiet}{whether to suppress the download progress bar.}

\item{overwrite}{whether to overwrite a previously downloaded statistical
publication file when re-running this function.}

\item{...}{additional arguments to be passed to \code{\link[utils:download.file]{utils::download.file()}}.}
}
\value{
A tibble containing the statistical publication data.
}
\description{
Download and import a specific statistical publication produced by APRA.

Please consult the \link{apra_stat_pubs} dataset to see which of APRA's
statistical publications are available in \code{readapra}.
}
\examples{
\donttest{
# Download and import the current MADIS data:
current_madis_data <-
  read_apra(stat_pub = "madis", cur_hist = "current")

# Examine the current MADIS data:
print(current_madis_data)
}

}
