% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs_local.R
\name{read_abs_local}
\alias{read_abs_local}
\title{Read and tidy locally-saved ABS time series spreadsheet(s)}
\usage{
read_abs_local(
  cat_no = NULL,
  filenames = NULL,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir()),
  use_fst = TRUE,
  metadata = TRUE
)
}
\arguments{
\item{cat_no}{character; a single catalogue number such as "6202.0".
When `cat_no` is specified, all local files in `path` corresponding to
the specified catalogue number will be imported.
For example, if you run `read_abs_local("6202.0")`, it will look in
"data/ABS/6202.0" and attempt to load any .xls files in that location.
If `cat_no`` is specified, `filenames` will be ignored.}

\item{filenames}{character vector of at least one filename of a
locally-stored ABS time series spreadsheet. For example, "6202001.xls" or
c("6202001.xls", "6202005.xls"). Ignored if a value is supplied to `cat_no`.
If `filenames` is blank and `cat_no` is blank, `read_abs_local()` will
attempt to read all .xls files in the directory specified with `path`.}

\item{path}{path to local directory containing ABS time series file(s).
Default is `Sys.getenv("R_READABS_PATH", unset = tempdir())`.
 If nothing is specified in `filenames` or `cat_no`,
`read_abs_local()` will attempt to read all .xls files in the directory
specified with `path`.}

\item{use_fst}{logical. If `TRUE` (the default) then, if an `fst` file of the
tidy data frame has already been saved in `path`, it is read immediately.}

\item{metadata}{logical. If `TRUE` (the default), a tidy data frame including
ABS metadata (series name, table name, etc.) is included in the output. If
`FALSE`, metadata is dropped.}
}
\description{
If you need to download and tidy time series data from the ABS,
use \code{read_abs()}. \code{read_abs_local()} imports and tidies data
from ABS time series spreadsheets that are already saved to your local drive.
}
\details{
Unlike \code{read_abs()}, the `table_title` column in the data frame
returned by \code{read_abs_local()} is blank. If you require `table_title`,
please use \code{read_abs()} instead.
}
\examples{

 # Load and tidy two specified files from the "data/ABS" subdirectory
 # of your working directory

 \donttest{lfs <- read_abs_local(c("6202001.xls", "6202005.xls"))}


}
