% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_erp.R
\name{read_erp}
\alias{read_erp}
\title{Download a tidy tibble containing the Estimated Residential Population from the ABS}
\usage{
read_erp(
  age_range = 0:100,
  sex = "Persons",
  states = c("Australia", "New South Wales", "Victoria", "Queensland", "South Australia",
    "Western Australia", "Tasmania", "Northern Territory",
    "Australian Capital Territory"),
  path = Sys.getenv("R_READABS_PATH", unset = tempdir()),
  show_progress_bars = TRUE,
  check_local = FALSE,
  retain_files = FALSE
)
}
\arguments{
\item{age_range}{numeric; default is "0:100". A vector containing ages in single
years for which an ERP is sought. The ABS top-code ages at 100.}

\item{sex}{character; default is "Persons". Other values are "Male" and
"Female". Multiple values allowed.}

\item{states}{character; default is "Australia". Other values are the full
or abbreviated names of the states and self-governing territories. Multiple
values allowed.}

\item{path}{character; default is "data/ABS". Only used if
retain_files is set to TRUE. Local directory in which to save
downloaded ABS time series spreadsheets.}

\item{show_progress_bars}{logical; TRUE by default. If set to FALSE, progress
bars will not be shown when ABS spreadsheets are downloading.}

\item{check_local}{logical; FALSE by default. See \code{?read_abs}.}

\item{retain_files}{logical; FALSE by default. When TRUE, the spreadsheets
downloaded from the ABS website will be saved in the
directory specified with 'path'.}
}
\description{
\code{read_erp()} uses the \code{read_abs()} function to download, import,
and tidy the Estimated Residential Population from the ABS. It allows the user
to specify age, sex and states/territories of interest. It returns a tibble
containing five columns: the date, the age range, sex and states that the ERP
corresponds to. This makes joining the ERP to another dataframe easy.
}
\examples{
\donttest{
# Create a tibble called 'erp' that contains the ERP index
# numbers for 30 June each year for Australia.

erp <- read_erp()
}

}
