% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_available_files.r
\name{show_available_files}
\alias{show_available_files}
\alias{get_available_files}
\title{Helper function to show the files available in a particular catalogue number.}
\usage{
show_available_files(catalogue_string, refresh = FALSE)

get_available_files(catalogue_string, refresh = FALSE)
}
\arguments{
\item{catalogue_string}{character string specifying the catalogue,
e.g. "labour-force-australia-detailed".
You can use \code{show_available_catalogues()} see all the possible catalogues,
or \code{search_catalogues()} to find catalogues that contain a given string.}

\item{refresh}{logical; `FALSE` by default. If `FALSE`, an internal table
of the available ABS catalogues is used. If `TRUE`, this table is refreshed
from the ABS website.}
}
\value{
A tibble containing the title of the file, the filename and the complete url.
}
\description{
To be used in conjunction with \code{get_abs_data_cube()}.
}
\details{
This function lists the possible files that are available in a catalogue.
The filename (or an unambiguous part of the filename) must be specified
as a string as an argument to \code{download_abs_data_cube}.

`get_available_files()` is an alias for `show_available_files()`.
}
\examples{
\dontrun{
show_available_files("labour-force-australia-detailed")
}

}
\seealso{
Other data cube functions: 
\code{\link{download_abs_data_cube}()},
\code{\link{search_catalogues}()},
\code{\link{show_available_catalogues}()}

Other data cube functions: 
\code{\link{download_abs_data_cube}()},
\code{\link{search_catalogues}()},
\code{\link{show_available_catalogues}()}
}
\concept{data cube functions}
