% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ods.R
\name{read_ods}
\alias{read_ods}
\alias{read_fods}
\title{Read Data From (F)ODS File}
\usage{
read_ods(
  path,
  sheet = 1,
  col_names = TRUE,
  col_types = NULL,
  na = "",
  skip = 0,
  formula_as_formula = FALSE,
  range = NULL,
  row_names = FALSE,
  strings_as_factors = FALSE,
  verbose = FALSE,
  as_tibble = TRUE,
  .name_repair = "unique"
)

read_fods(
  path,
  sheet = 1,
  col_names = TRUE,
  col_types = NULL,
  na = "",
  skip = 0,
  formula_as_formula = FALSE,
  range = NULL,
  row_names = FALSE,
  strings_as_factors = FALSE,
  verbose = FALSE,
  as_tibble = TRUE,
  .name_repair = "unique"
)
}
\arguments{
\item{path}{path to the (f)ods file.}

\item{sheet}{sheet to read. Either a string (the sheet name), or an integer sheet number. The default is 1.}

\item{col_names}{logical, indicating whether the file contains the names of the variables as its first line. Default is TRUE.}

\item{col_types}{Either NULL to guess from the spreadsheet or refer to \code{\link[readr:type_convert]{readr::type_convert()}} to specify cols specification. It can also be a shorthand such as "ccf" ("character", "character", "factor"), a list, or an object created by \code{\link[readr:cols]{readr::cols()}}. NA will return a data frame with all columns being "characters". Please note that it will not speed up the reading by a lot by specifying this parameter explicitly. It is more for accuracy.}

\item{na}{Character vector of strings to use for missing values. By default read_ods converts blank cells to missing data. It can also be set to
NULL, so that empty cells are treated as NA.}

\item{skip}{the number of lines of the data file to skip before beginning to read data. If this parameter is larger than the total number of lines in the ods file, an empty data frame is returned.}

\item{formula_as_formula}{logical, a switch to display formulas as formulas "SUM(A1:A3)" or as the resulting value "3"... or "8".. . Default is FALSE.}

\item{range}{selection of rectangle using Excel-like cell range, such as \code{range = "D12:F15"} or \code{range = "R1C12:R6C15"}. Cell range processing is handled by the \code{\link[=cellranger]{cellranger}} package. If sheet name is in the range, such as \code{range = "Sheet2!A2:B7"}, this sheet name is used instead of the provided \code{sheet}. If \code{sheet} is not the default value (1), a warning is given.}

\item{row_names}{logical, indicating whether the file contains the names of the rows as its first column. Default is FALSE.}

\item{strings_as_factors}{logical, if character columns to be converted to factors. Default is FALSE.}

\item{verbose}{logical, if messages should be displayed. Default is FALSE.}

\item{as_tibble}{logical, if the output should be a tibble (as opposed to a data.frame). Default is TRUE.}

\item{.name_repair}{A string or function passed on as \code{.name_repair} to \code{\link[tibble:as_tibble]{tibble::as_tibble()}}
\itemize{
\item \code{"minimal"}: No name repair
\item \code{"unique"} : Make sure names are unique and not empty
\item \code{"check_unique"}: Check names are unique, but do not repair
\item \code{"universal"} : Checks names are unique and valid R variables names in scope
\item A function to apply custom name repair.
}

Default is \code{"unique"}.}
}
\value{
A tibble (\code{tibble}) or data frame (\code{data.frame}) containing a representation of data in the (f)ods file.
}
\description{
read_ods is a function to read a single sheet from an (f)ods file and return a data frame. For flat ods files (.fods or .xml),
use (\code{read_fods}).
}
\examples{
\dontrun{
# Read an ODS file
read_ods("starwars.ods")
# Read a specific sheet, e.g. the 2nd sheet
read_ods("starwars.ods", sheet = 2)
# Read a specific range, e.g. A1:C11
read_ods("starwars.ods", sheet = 2, range = "A1:C11")
# Read an FODS file
read_fods("starwars.fods")
# Read a specific sheet, e.g. the 2nd sheet
read_fods("starwars.fods", sheet = 2)
# Read a specific range, e.g. A1:C11
read_fods("starwars.fods", sheet = 2, range = "A1:C11")
# Give a warning and read from Sheet1 (not 2)
read_fods("starwars.fods", sheet = 2, range = "Sheet1!A1:C11")
# Specifying col_types as shorthand, the third column as factor; other by guessing
read_ods("starwars.ods", col_types = "??f")
# Specifying col_types as list
read_ods("starwars.ods", col_types = list(species = "f"))
}
}
\author{
Peter Brohan \href{mailto:peter.brohan+cran@gmail.com}{peter.brohan+cran@gmail.com}, Chung-hong Chan \href{mailto:chainsawtiney@gmail.com}{chainsawtiney@gmail.com}, Gerrit-Jan Schutten \href{mailto:phonixor@gmail.com}{phonixor@gmail.com}
}
