% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{parseGT3X}
\alias{parseGT3X}
\title{Parse activity samples from a GT3X file}
\usage{
parseGT3X(
  filename,
  max_samples,
  scale_factor,
  sample_rate,
  start_time,
  verbose = FALSE,
  debug = FALSE,
  impute_zeroes = FALSE
)
}
\arguments{
\item{filename}{(char*) path to a log.bin file inside the unzipped gt3x folder, which contains the activity samples}

\item{max_samples}{Maximum number of rows to parse. The returned matrix will always contain this number of rows, having zeroes if
not data is found.}

\item{scale_factor}{Scale factor for the activity samples.}

\item{sample_rate}{sampling rate for activity samples.}

\item{start_time}{starting time of the sample recording.}

\item{verbose}{Print the parameters from the log.bin file and other messages?}

\item{debug}{Print information for every activity second}

\item{impute_zeroes}{Impute zeros in case there are missingness?}
}
\value{
Returns a matrix with max_samples rows and 3 columns with the acceleration samples.
The matrix has attributes
"time_index", "missingness", "start_time_log", "sample_rate", "impute_zeroes".
}
\description{
Parse activity samples from a GT3X file
}
