% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reacttools.R
\name{createReactShinyInput}
\alias{createReactShinyInput}
\title{Create a React-based input}
\usage{
createReactShinyInput(
  inputId,
  class,
  dependencies,
  default = NULL,
  configuration = list(),
  container = htmltools::tags$div
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{class}{Space-delimited list of CSS class names that should identify
this input type in the browser.}

\item{dependencies}{HTML dependencies to include in addition to those
supporting React. Must contain at least one dependency, that of the input's
implementation.}

\item{default}{Initial value.}

\item{configuration}{Static configuration data.}

\item{container}{Function to generate an HTML element to contain the input.}
}
\value{
Shiny input suitable for inclusion in a UI.
}
\description{
Create a React-based input
}
\examples{
myInput <- function(inputId, default = "") {
  # The value of createReactShinyInput should be returned from input constructor functions.
  createReactShinyInput(
    inputId,
    "myinput",
    # At least one htmlDependency must be provided -- the JavaScript implementation of the input.
    htmlDependency(
      name = "my-input",
      version = "1.0.0",
      src = "www/mypackage/myinput",
      package = "mypackage",
      script = "myinput.js"
    ),
    default
  )
}
}
