% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_to_mapset.R
\name{raster_to_mapset}
\alias{raster_to_mapset}
\title{Import rasters into GRASS mapset}
\usage{
raster_to_mapset(
  rasters,
  as_integer = rep(FALSE, length(rasters)),
  overwrite = FALSE,
  max_memory = 300,
  ...
)
}
\arguments{
\item{rasters}{A character vector of filenames of rasters to import.}

\item{as_integer}{A logical vector indicating whether each raster should be imported strictly in integer format. Defaults to \code{FALSE}.}

\item{overwrite}{A logical indicating whether the overwrite flag should be used. If \code{FALSE}, then the corresponding raster is allowed to retain its original format. Defaults to \code{FALSE}. May cause value truncation if improperly used.}

\item{max_memory}{Max memory used in memory swap mode (MB). Defaults to \code{300}.}

\item{...}{Additional arguments to \code{r.import}.}
}
\value{
A vector of raster layer names in the GRASS mapset.
}
\description{
GRASS can only deal with raster and vector data in a GRASS mapset. This function takes external rasters and imports them into the current GRASS mapset.
}
\examples{
 
# Will only run if a GRASS session is initialised
if(check_running()){
   dem <- system.file("extdata", "dem.tif", package = "rdwplus")
   raster_to_mapset(dem)
}
}
