% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_streams.R
\name{derive_streams}
\alias{derive_streams}
\title{Extract streams from a flow accumulation raster}
\usage{
derive_streams(
  dem,
  flow_acc,
  out_rast,
  out_vect,
  min_acc = 1000,
  min_length = 0,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{dem}{Name of an elevation raster in the current GRASS mapset.}

\item{flow_acc}{Name of a flow accumulation raster in the current GRASS mapset.}

\item{out_rast}{Name of the output raster dataset of stream lines. File extensions should not matter.}

\item{out_vect}{Name of the output vector dataset of stream lines. Should be WITHOUT .shp extension.}

\item{min_acc}{The minimum accumulation value that a cell needs to be classified as a stream. Defaults to \code{1000}.}

\item{min_length}{The minimum length of a stream segment in cells. Defaults to \code{0}.}

\item{overwrite}{A logical indicating whether the output should be allowed to overwrite existing files. Defaults to \code{FALSE}.}

\item{...}{Additional arguments to \code{r.stream.extract}.}
}
\value{
Nothing. A vector dataset with the name \code{basename(out)} will appear in the current GRASS mapset.
}
\description{
Derive a raster and a vector layer of stream lines from a flow accumulation raster.
}
\examples{
 
# Will only run if GRASS is running
if(check_running()){
# Retrieve paths to data sets
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
lus <- system.file("extdata", "landuse.tif", package = "rdwplus")
sts <- system.file("extdata", "site.shp", package = "rdwplus")
stm <- system.file("extdata", "streams.shp", package = "rdwplus")

# Set environment
set_envir(dem)

# Get other data sets (stream layer, sites, land use, etc.)
raster_to_mapset(lus)
vector_to_mapset(c(stm, sts))

# Reclassify streams
out_stream <- paste0(tempdir(), "/streams.tif")
rasterise_stream("streams", out_stream, TRUE)
reclassify_streams("streams.tif", "streams01.tif", overwrite = TRUE)

# Burn in the streams to the DEM
burn_in("dem.tif", "streams01.tif", "burndem.tif", overwrite = TRUE)

# Fill dem
fill_sinks("burndem.tif", "filldem.tif", "fd1.tif", "sinks.tif", overwrite = TRUE)

# Derive flow direction and accumulation grids
derive_flow("dem.tif", "fd.tif", "fa.tif", overwrite = T)

# Derive a new stream raster from the FA grid
derive_streams("dem.tif", "fa.tif", "new_stm.tif", "new_stm", min_acc = 200, overwrite = T)
}
}
