% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_shared.R
\name{drop_share}
\alias{drop_share}
\title{Creates and returns a shared link to a file or folder.}
\usage{
drop_share(path = NULL, requested_visibility = "public",
  link_password = NULL, expires = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{requested_visibility}{Can be `public`, `team_only`, or `password`. If the
password option is chosen one must specify the `link_password`. Note that
for basic (i.e. free) Dropbox accounts, the only option is to publicly
share. Private sharing requires a pro account.}

\item{link_password}{The password needed to access the document if
`request_visibility` is set to password.}

\item{expires}{Set the expiry time. The timestamp format is
"\%Y-\%m-\%dT\%H:\%M:\%SZ"). If no timestamp is specified, link never expires}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
Creates and returns a shared link to a file or folder.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mt.csv")
drop_upload("mt.csv")
drop_share("mt.csv")
# If you have a pro account, you can share files privately
drop_share("mt.csv", requested_visibility = "password", link_password = "test")
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#sharing-create_shared_link_with_settings}{API documentation}
}
