% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_file_ops.R
\name{drop_move}
\alias{drop_move}
\title{Moves a file or folder to a new location.}
\usage{
drop_move(from_path = NULL, to_path = NULL, allow_shared_folder = FALSE,
  autorename = FALSE, allow_ownership_transfer = FALSE, verbose = FALSE,
  dtoken = get_dropbox_token())
}
\arguments{
\item{from_path}{Source file or folder}

\item{to_path}{destination file or folder}

\item{allow_shared_folder}{If \code{TRUE}, copy will copy contents in shared
folder}

\item{autorename}{If there's a conflict, have the Dropbox server try to
autorename the file to avoid the conflict.}

\item{allow_ownership_transfer}{Allow moves by owner even if it would result
in an ownership transfer for the content being moved. This does not apply
to copies. The default for this field is False.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
Moves a file or folder to a new location.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mt.csv")
drop_upload("mt.csv")
drop_create("drop_test2")
drop_move("mt.csv", "drop_test2/mt.csv")
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#files-move_v2}{API documentation}
}
