% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_dir.R
\name{drop_dir}
\alias{drop_dir}
\title{List folder contents and associated metadata.}
\usage{
drop_dir(path = "", recursive = FALSE, include_media_info = FALSE,
  include_deleted = FALSE, include_has_explicit_shared_members = FALSE,
  include_mounted_folders = TRUE, limit = NULL, cursor = FALSE,
  dtoken = get_dropbox_token())
}
\arguments{
\item{path}{path to folder in Dropbox to list contents of. Defaults to the root directory.}

\item{recursive}{If TRUE, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. Defaults to FALSE.}

\item{include_media_info}{If TRUE, FileMetadata.media_info is set for photo and video. Defaults to FALSE.}

\item{include_deleted}{If TRUE, the results will include entries for files and folders that used to exist but were deleted. Defaults to FALSE.}

\item{include_has_explicit_shared_members}{If TRUE, the results will include a flag for each file indicating whether or not that file has any explicit members. Defaults to FALSE.}

\item{include_mounted_folders}{If TRUE, the results will include entries under mounted folders which includes app folder, shared folder and team folder. Defaults to TRUE.}

\item{limit}{The maximum number of results to return per request. Note: This is an approximate number and there can be slightly more entries returned in some cases. Defaults to NULL, no limit.}

\item{cursor}{string or boolean: \itemize{
  \item{If FALSE, return metadata of items in \code{path}}
  \item{If TRUE, return a cursor to be used for detecting changed later}
  \item{If a string, return metadata of changed items since the cursor was fetched}
}}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\value{
Either a \code{tbl_df} of items in folder, one row per file or folder, with metadata values as columns, or a character string giving a cursor to be used later for change detection (see \code{cursor}).
}
\description{
Can be used to either see all items in a folder, or only items that have changed since a previous request was made.
}
\examples{
\dontrun{

  # list files in root directory
  drop_dir()

  # get a cursor from root directory,
  # upload a new file,
  # return only information about new file
  cursor <- drop_dir(cursor = TRUE)
  drop_upload("some_new_file")
  drop_dir(cursor = cursor)
}

}
