% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsensitivity.R
\name{rdsensitivity}
\alias{rdsensitivity}
\title{Sensitivity analysis for RD designs under local randomization}
\usage{
rdsensitivity(Y, R, cutoff = 0, wlist, tlist, ci, statistic = "diffmeans",
  nodraw = FALSE, p = 0, evalat = "cutoff", kernel = "uniform",
  reps = 1000, seed = "", fuzzy = "", quietly = FALSE)
}
\arguments{
\item{Y}{a vector containing the values of the outcome variable.}

\item{R}{a vector containing the values of the running variable.}

\item{cutoff}{the RD cutoff (default is 0).}

\item{wlist}{the list of window lengths to be evaluated. By default the program constructs 10 windows around the cutoff, the first one including 10 treated and control observations and adding 5 observations to each group in subsequent windows.}

\item{tlist}{the list of values of the treatment effect under the null to be evaluated. By default the program employs ten evenly spaced points within the asymptotic confidence interval for a constant treatment effect in the smallest window to be used.}

\item{ci}{returns the confidence interval corresponding to the indicated window length. \code{ci} has to be a scalar or a two-dimensional vector, where the first value needs to be one of the values in \code{wlist}. The second value, if specified, indicates the level of the confidence interval. Default level is .05 (95\% level CI).}

\item{statistic}{the statistic to be used in the balance tests. Allowed options are \code{diffmeans} (difference in means statistic), \code{ksmirnov} (Kolmogorov-Smirnov statistic) and \code{ranksum} (Wilcoxon-Mann-Whitney standardized statistic). Default option is \code{diffmeans}. The statistic \code{ttest} is equivalent to \code{diffmeans} and included for backward compatibility.}

\item{nodraw}{suppresses contour plot.}

\item{p}{the order of the polynomial for outcome adjustment model. Default is 0.}

\item{evalat}{specifies the point at which the adjusted variable is evaluated. Allowed options are \code{cutoff} and \code{means}. Default is \code{cutoff}.}

\item{kernel}{specifies the type of kernel to use as weighting scheme. Allowed kernel types are \code{uniform} (uniform kernel), \code{triangular} (triangular kernel) and \code{epan} (Epanechnikov kernel). Default is \code{uniform}.}

\item{reps}{number of replications. Default is 1000.}

\item{seed}{the seed to be used for the randomization tests.}

\item{fuzzy}{indicates that the RD design is fuzzy. \code{fuzzy} can be specified as a vector containing the values of the endogenous treatment variable, or as a list where the first element is the vector of endogenous treatment values and the second element is a string containing the name of the statistic to be used. Allowed statistics are \code{ar} (Anderson-Rubin statistic) and \code{tsls} (2SLS statistic). Default statistic is \code{ar}. The \code{tsls} statistic relies on large-sample approximation.}

\item{quietly}{suppresses the output table.}
}
\value{
\item{tlist}{treatment effects grid}
\item{wlist}{window grid}
\item{results}{table with corresponding p-values for each window and treatment effect pair.}
\item{ci}{confidence interval (if \code{ci} is specified).}
}
\description{
\code{rdsensitivity} analyze the sensitivity of randomization p-values
and confidence intervals to different window lengths.
}
\examples{
# Toy dataset
R <- runif(100,-1,1)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(100)
# Sensitivity analysis
# Note: low number of replications to speed up process.
# The user should increase the number of replications.
tmp <- rdsensitivity(Y,R,wlist=seq(.75,2,by=.25),tlist=seq(0,5,by=1),reps=500)


}
\references{
M.D. Cattaneo, B. Frandsen and R. Titiunik. (2015).  \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Frandsen-Titiunik_2015_JCI.pdf}{Randomization Inference in the Regression Discontinuity Design: An Application to Party Advantages in the U.S. Senate}. \emph{Journal of Causal Inference} 3(1): 1-24.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2016). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Titiunik-VazquezBare_2016_Stata.pdf}{Inference in Regression Discontinuity Designs under Local Randomization}. \emph{Stata Journal} 16(2): 331-367.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Titiunik-VazquezBare_2017_JPAM.pdf}{Comparing Inference Approaches for RD Designs: A Reexamination of the Effect of Head Start on Child Mortality}. \emph{Journal of Policy Analysis and Management}, forthcoming.
}
\author{
Matias Cattaneo, University of Michigan. \email{cattaneo@umich.edu}

Rocio Titiunik, University of Michigan. \email{titiunik@umich.edu}

Gonzalo Vazquez-Bare, University of Michigan. \email{gvazquez@umich.edu}
}
