% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docDscr_variables.R
\name{ddi_usage}
\alias{ddi_usage}
\alias{ddi_attribute}
\alias{ddi_selector}
\alias{ddi_specificElements}
\title{usage and its child nodes}
\usage{
ddi_usage(...)

ddi_attribute(...)

ddi_selector(...)

ddi_specificElements(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Defines where in the instance the controlled vocabulary which is identified
is utilized. A controlled vocabulary may occur either in the content of an
element or in an attribute on an element. The usage can either point to a
collection of elements using an XPath via the selector element or point to a
more specific collection of elements via their identifier using the
specificElements element. If the controlled vocabulary occurs in an
attribute within the element, the attribute element identifies the specific
attribute. When specific elements are specified, an authorized code value
may also be provided. If the current value of the element or attribute
identified is not in the controlled vocabulary or is not identical to a
code value, the authorized code value identifies a valid code value
corresponding to the meaning of the content in the element or attribute.
More information on this element, especially the allowed attributes, can be
found in the references.
}
\details{
\emph{Parent nodes}

\code{usage} is contained in \code{controlledVocabUsed}.

\emph{usage specific child nodes}
\itemize{
\item \code{ddi_attribute()} identifies an attribute within the element(s) identified
by the selector or specificElements in which the controlled vocabulary is
used. The fully qualified name used here must correspond to that in the
instance, which is to say that if the attribute is namespace qualified, the
prefix used here must match that which is defined in the instance.
\item \code{ddi_selector()} identifies a collection of elements in which a controlled
vocabulary is used. This is a simplified XPath which must correspond to the
actual instance in which it occurs, which is to say that the fully qualified
element names here must correspond to those in the instance. This XPath can
only identify elements and does not allow for any predicates. The XPath must
either be rooted or deep.
\item \code{ddi_specificElements()} identifies a collection of specific elements via
their identifiers in the refs attribute, which allows for a tokenized list
of identifier values which must correspond to identifiers which exist in the
instance. The authorizedCodeValue attribute can be used to provide a valid
code value corresponding to the meaning of the content in the element or
attribute when the identified element or attribute does not use an actual
valid value from the controlled vocabulary.
}
}
\examples{
ddi_usage(ddi_selector("/codeBook/stdyDscr/method/dataColl/timeMeth"))

ddi_usage(ddi_selector("/codeBook/stdyDscr/method/dataProcessing"), ddi_attribute("type"))

ddi_usage(ddi_specificElements(refs = "ICPSR4328timeMeth", authorizedCodeValue = "CrossSection"))

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/usage.html}{usage documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/attribute.html}{attribute documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/selector.html}{selector documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/specificElements.html}{specificElements documentation}
}
