% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation.R
\name{ddi_prodStmt}
\alias{ddi_prodStmt}
\alias{ddi_copyright}
\alias{ddi_fundAg}
\alias{ddi_grantNo}
\alias{ddi_prodDate}
\alias{ddi_prodPlac}
\alias{ddi_software}
\title{prodStmt and its child nodes}
\usage{
ddi_prodStmt(...)

ddi_copyright(...)

ddi_fundAg(...)

ddi_grantNo(...)

ddi_prodDate(...)

ddi_prodPlac(...)

ddi_software(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Production statement for the work at the appropriate level: marked-up document;
marked-up document source; study; study description, other material;
other material for study. More information on these elements, especially
their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{prodStmt} is contained in the following elements: \code{citation}; \code{docSrc};
\code{fileCitation}; and \code{sourceCitation}.

\emph{prdStmt specific child nodes}

\code{ddi_copyright()} is the copyright statement for the work at the appropriate
level. Copyright for data collection (codeBook/stdyDscr/citation/prodStmt/copyright)
maps to Dublin Core Rights. Inclusion of this element is recommended.

\code{ddi_fundAg()} is the source(s) of funds for production of the work. If
different funding agencies sponsored different stages of the production
process, use the "role" attribute to distinguish them.

\code{ddi_grantNo()} is the grant/contract number of the project that sponsored
the effort. If more than one, indicate the appropriate agency using the
"agency" attribute. If different funding agencies sponsored different stages
of the production process, use the "role" attribute to distinguish the grant
numbers.

\code{ddi_prodDate()} is the date when the marked-up document/marked-up document
source/data collection/other material(s) were produced (not distributed or
archived). The ISO standard for dates (YYYY-MM-DD) is recommended for use
with the date attribute. Production date for data collection
(codeBook/stdyDscr/citation/prodStmt/prodDate) maps to Dublin Core Date element.

\code{ddi_prodPlac()} is the address of the archive or organization that produced
the work.

\code{ddi_software()} is the software used to produce the work. A "version"
attribute permits specification of the software version number. The
"date" attribute is provided to enable specification of the date (if any)
for the software release. The ISO standard for dates (YYYY-MM-DD) is
recommended for use with the date attribute.
}
\examples{
ddi_prodStmt()

# Functions that need to be wrapped in ddi_prodStmt()

ddi_copyright("Copyright(c) ICPSR, 2000")

ddi_fundAg(abbr = "NSF", role = "infrastructure", "National Science Foundation")

ddi_grantNo(agency = "Bureau of Justice Statistics", "J-LEAA-018-77")

ddi_prodDate(date = "2022-01-01", "January 1, 2022")

ddi_prodPlac("Place of production")

ddi_software(version = "6.12", "SAS")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/prodStmt.html}{prodStmt documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/copyright.html}{copyright documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/fundAg.html}{fundAg documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/grantNo.html}{grantNo documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/prodDate.html}{prodDate documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/prodPlac.html}{prodPlac documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/software.html}{software documentation}
}
