% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-process-tracing.R
\name{process_tracing_estimator}
\alias{process_tracing_estimator}
\title{Process tracing estimator}
\usage{
process_tracing_estimator(causal_model, query, data, strategies)
}
\arguments{
\item{causal_model}{a model generated by \code{CausalQueries}}

\item{query}{a causal query of interest}

\item{data}{a single row dataset with data on nodes in the model}

\item{strategies}{a vector describing sets of nodes to be examined e.g. c("X", "X-Y")}
}
\value{
a data.frame of estimates
}
\description{
Draw conclusions from a model given a query, data, and process tracing strategies
}
\details{
See https://book.declaredesign.org/observational-causal.html#process-tracing
}
\examples{

process_tracing_estimator(
  CausalQueries::make_model("X -> Y"),
  "Y[X=1] > Y[X=0]",
  data.frame(X=1, Y = 1),
  "X-Y")

}
