% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_search.R
\name{dc_search}
\alias{dc_search}
\alias{dc_facet}
\alias{dc_stats}
\alias{dc_mlt}
\title{DataCite Solr web service for search, facet, stats,
and mlt queries}
\usage{
dc_search(..., proxy = NULL, callopts = list())

dc_facet(..., proxy = NULL, callopts = list())

dc_stats(..., proxy = NULL, callopts = list())

dc_mlt(..., proxy = NULL, callopts = list())
}
\arguments{
\item{...}{Solr parameters passed on to the respective \code{solrium}
package function. See Details below.}

\item{proxy}{List of arguments for a proxy connection, including one or
more of: url, port, username, password, and auth. See
\code{\link[crul]{proxy}} for help, which is used to construct the
proxy connection.}

\item{callopts}{Curl options in a named list passed on to
\code{\link[crul]{HttpClient}}, see \code{\link[crul]{curl-options}}}
}
\description{
DataCite Solr web service for search, facet, stats,
and mlt queries
}
\details{
See the \code{solrium} package documentation for available
parameters. For each of \code{dc_search}, \code{dc_facet}, \code{dc_stats},
and \code{dc_mlt} see the equivalently named function in \code{solrium}:

\itemize{
\item \code{dc_search} - \code{\link[solrium]{solr_search}}
\item \code{dc_facet} - \code{\link[solrium]{solr_facet}}
\item \code{dc_stats} - \code{\link[solrium]{solr_stats}}
\item \code{dc_mlt} - \code{\link[solrium]{solr_mlt}}
}

Fields you can search on and retrieve back are:
\itemize{
\item doi
\item creator
\item publisher
\item publicationYear
\item title
\item alternateIdentifier
\item contributor
\item date
\item description
\item format
\item language
\item relatedIdentifier
\item resourceType
\item resourceTypeGeneral
\item rights
\item size
\item subject
\item version
\item allocator symbol of the DataCite member (e.g. BL = British Library)
\item datacentre symbol of the datacentre, which uploaded the metadata
(e.g. BL.ADS = Archeology Data Service)
\item indexed datestamp of indexing
\item prefix DOI prefix (e.g. 10.5284)
\item refQuality reference quality flag (1 or 0)
\item uploaded datestamp of metadata uploading
}

If you want to use \code{wt='csv'} you'll need \code{solrium} package
version \code{0.1.8.99} or greater. Installation instructions at
\url{https://github.com/ropensci/solrium#quick-start}.
}
\examples{
library(crul)
url <- "https://search.datacite.org/api"
if (crul::HttpClient$new(url=url)$get()$success()) {

# Search
## various searches
### containing laser
dc_search(q = "laser", fl=c('doi','publicationYear'), rows=5)

### containing laser and safety
dc_search(q = "laser safety", fl=c('doi','publicationYear'),
  rows=5)

### containing laser and not medicine
dc_search(q = "laser -medicine", fl=c('doi',
  'publicationYear'), rows=5)

}

\dontrun{
### containing laser and red or green
dc_search(q = "laser AND (red OR green)", fl=c('doi',
  'publicationYear'), rows=5)

### containing wind turbine as a phrase in the title
dc_search(q = 'title:"wind turbine"', fl=c('doi','title'),
  rows=5)

### containing geology in metadata field subject
dc_search(q = "subject:geology", fl=c('doi','subject'),
  rows=5)

### belonging to DataCite members BL or TIB
dc_search(q = "allocator:(BL OR TIB)", fl=c('doi','allocator'),
  rows=5)

### published between 2000 and 2005
dc_search(q = "publicationYear:[2000 TO 2005]",
  fl=c('doi','publicationYear'), rows=5)

### uploaded to DataCite in the last 5 days
dc_search(q = "uploaded:[NOW-5DAYS TO NOW]",
  fl=c('doi','uploaded'), rows=5)

## search with csv output
### If you want to use wt=csv, install development version of
### solr package, see Details
dc_search(q = 'wind', fl=c('doi','title'), wt='csv')

# Faceting
dc_facet(q = "wind", facet.field='publisher_facet')

# Stats
dc_stats(q = "ecology", stats.field='date')

# More like this (aka mlt)
dc_mlt(q = "ecology", mlt.fl='title', mlt.count=5,
  fl=c('doi','title'))

}
}
\references{
\url{https://support.datacite.org/docs/datacite-search-user-documentation}
}
