% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_oai_listrecords.R
\name{dc_oai_listrecords}
\alias{dc_oai_listrecords}
\title{List the records in the DataCite metadata repository.}
\usage{
dc_oai_listrecords(from = NULL, until = NULL, set = NULL,
  prefix = "oai_dc", token = NULL, ...)
}
\arguments{
\item{from}{specifies that records returned must have been created/update/deleted
on or after this date.}

\item{until}{specifies that records returned must have been created/update/deleted
on or before this date.}

\item{set}{specifies the set that returned records must belong to.}

\item{prefix}{specifies the metadata format that the records will be
returned in. One of: oai_dc (default), oai_datacite, or datacite. See
\code{Prefixes} for more info.}

\item{token}{a token previously provided by the server to resume a request
where it last left off.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List the records in the DataCite metadata repository.
}
\examples{
\dontrun{
dc_oai_listrecords(from = '2011-06-01T', until = '2011-07-01T')
dc_oai_listrecords(from = '2011-06-01T', until = '2011-11-01T', set = "REFQUALITY")
}
}
