% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rdaccahp.r
\name{plot.rdaccahp}
\alias{plot.rdaccahp}
\title{Plot for a \code{\link{rdacca.hp}} object}
\usage{
\method{plot}{rdaccahp}(x, plot.perc = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{rdacca.hp}} object.}

\item{plot.perc}{Logical;if TRUE, the bar plot (based on ggplot2 package) of the percentage to individual effects of variables or groups towards total explained variation, the default is FALSE to show plot with original individual effects.}

\item{...}{unused}
}
\value{
a ggplot object
}
\description{
Plot for a \code{\link{rdacca.hp}} object
}
\examples{
library(vegan)
data(mite)
data(mite.env)
mite.hel <- decostand(mite, "hellinger")
avc<-rdacca.hp(mite.hel,mite.env,method="RDA",type="adjR2")
plot(avc)
plot(avc, plot.perc=TRUE)
}
\author{
{Jiangshan Lai} \email{lai@ibcas.ac.cn}
}
