#' Brown and Hudson's (2002, p. 124) Table 4.8 Item analysis data (first 10 items only)
#'
#' A data set containing the scored responses to first 10 items of a
#' test and the total scores for 15 people
#' 
#' @docType data
#' @keywords datasets
#' @name bh_item
#' @usage data(bh_item) 
#' @format A data frame with 15 rows and 12 variables
#' 
#' \itemize{
#' \item Students. Student names.
#' \item Q1. Question 1.
#' \item Q2. Question 2.
#' \item Q3. Question 3.
#' \item Q4. Question 4.
#' \item Q5. Question 5.
#' \item Q6. Question 6.
#' \item Q7. Question 7.
#' \item Q8. Question 8.
#' \item Q9. Question 9.
#' \item Q10. Question 10.
#' \item Total. Total score.
#' }
#' 
#' 
#' @source Brown and Hudson (2002)
NULL

#' Brown and Hudson's (2002, p. 153) Table 5.1a Data for 45 examinees on 30 test items
#'
#' A data set containing the 45 scored responses to 30 items on a
#' test of Listening (1-10), Reading (11-20), and Grammar (20-30)
#' 
#' @docType data
#' @keywords datasets
#' @name bh_depend
#' @usage data(bh_depend) 
#' @format A data frame with 45 rows and 30 variables
#' 
#' \itemize{
#' \item ID. ID numbers.
#' \item L_1. Listening question 1.
#' \item L_2. Listening question 2.
#' \item L_3. Listening question 3.
#' \item L_4. Listening question 4.
#' \item L_5. Listening question 5.
#' \item L_6. Listening question 6.
#' \item L_7. Listening question 7.
#' \item L_8. Listening question 8.
#' \item L_9. Listening question 9.
#' \item L_10. Listening question 10.
#' \item R_1. Reading question 1.
#' \item R_2. Reading question 2.
#' \item R_3. Reading question 3.
#' \item R_4. Reading question 4.
#' \item R_5. Reading question 5.
#' \item R_6. Reading question 6.
#' \item R_7. Reading question 7.
#' \item R_8. Reading question 8.
#' \item R_9. Reading question 9.
#' \item R_10. Reading question 10.
#' \item G_1. Grammar question 1.
#' \item G_2. Grammar question 2.
#' \item G_3. Grammar question 3.
#' \item G_4. Grammar question 4.
#' \item G_5. Grammar question 5.
#' \item G_6. Grammar question 6.
#' \item G_7. Grammar question 7.
#' \item G_8. Grammar question 8.
#' \item G_9. Grammar question 9.
#' \item G_10. Grammar question 10.
#' }
#' 
#' @source Brown and Hudson (2002)
NULL

#' Brown and Hudson's (2002, p. 177) Table 5.8 Data for 30 examinees 
#' on 30 test items with an ID column and a total score column.
#'
#' A data set containing the 30 scored responses to 30 items on a test
#' 
#' @docType data
#' @keywords datasets
#' @name bh_gstudy
#' @usage data(bh_gstudy) 
#' @format A data frame with 30 rows and 32 variables
#' 
#' \itemize{
#' \item ID. ID numbers.
#' \item I1. Item 1
#' \item I2. Item 2
#' \item I3. Item 3
#' \item I4. Item 4
#' \item I5. Item 5
#' \item I6. Item 6
#' \item I7. Item 7
#' \item I8. Item 8
#' \item I9. Item 9
#' \item I10. Item 10
#' \item I11. Item 11
#' \item I12. Item 12
#' \item I13. Item 13
#' \item I14. Item 14
#' \item I15. Item 15
#' \item I16. Item 16
#' \item I17. Item 17
#' \item I18. Item 18
#' \item I19. Item 19
#' \item I20. Item 20
#' \item I21. Item 21
#' \item I22. Item 22
#' \item I23. Item 23
#' \item I24. Item 24
#' \item I25. Item 25
#' \item I26. Item 26
#' \item I27. Item 27
#' \item I28. Item 28
#' \item I29. Item 29
#' \item I30. Item 30
#' \item SCORE. Total score
#' }
#' 
#' @source Brown and Hudson (2002)
NULL



#' Subkoviak's (1988) table of approximate values of the agreement coefficient
#'
#' @docType data
#' @keywords datasets
#' @name sub_agree_coef
#' @usage data(sub_agree_coef) 
#' @format A data frame with 21 rows and 10 columns
#' 
#' \itemize{
#' \item z. z cut-score for test.
#' \item r_0.1. Reliability of 0.1.
#' \item r_0.1. Reliability of 0.2.
#' \item r_0.1. Reliability of 0.3.
#' \item r_0.1. Reliability of 0.4.
#' \item r_0.1. Reliability of 0.5.
#' \item r_0.1. Reliability of 0.6.
#' \item r_0.1. Reliability of 0.7.
#' \item r_0.1. Reliability of 0.8.
#' \item r_0.1. Reliability of 0.9.
#' }
#' 
#' @source Subkoviak (1988)
NULL

#' Subkoviak's (1988) table of approximate values of the kappa coefficient
#'
#' @docType data
#' @keywords datasets
#' @name sub_kappa_coef
#' @usage data(sub_kappa_coef) 
#' @format A data frame with 21 rows and 10 columns
#' 
#' \itemize{
#' \item z. z cut-score for test.
#' \item r_0.1. Reliability of 0.1.
#' \item r_0.1. Reliability of 0.2.
#' \item r_0.1. Reliability of 0.3.
#' \item r_0.1. Reliability of 0.4.
#' \item r_0.1. Reliability of 0.5.
#' \item r_0.1. Reliability of 0.6.
#' \item r_0.1. Reliability of 0.7.
#' \item r_0.1. Reliability of 0.8.
#' \item r_0.1. Reliability of 0.9.
#' }
#' 
#' @source Subkoviak (1988)
NULL