% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubWindow.R
\name{window.data.frame}
\alias{window.data.frame}
\title{Get a sub window from a data.frame}
\usage{
\method{window}{data.frame}(x, new.window, intersect = TRUE, ...)
}
\arguments{
\item{x}{A data.frame. Must have
columns labelled x,y,z specifying cartesian coordinates, or
columns labelled theta, phi specifying colatitude and longitude
respectively.}

\item{new.window}{A single \code{\link{CMBWindow}} object or a list of them.}

\item{intersect}{A boolean that determines
the behaviour when \code{new.window} is a list containing BOTH
regular type and "minus" type windows together (see details).}

\item{...}{Unused arguments.}
}
\value{
A data.frame containing the data in \code{x} restricted to the
CMBWindow \code{new.window}
}
\description{
This function returns a
data.frame containing the data in \code{x} restricted to the
CMBWindow \code{new.window}
}
\details{
Windows that are tagged with \code{set.minus} (see \code{\link{CMBWindow}})
are treated differently from other windows.

If the argument is a list of CMBWindows, then interiors of all windows whose
winType does not include "minus" are united (let \eqn{A} be their union) and
exteriors of all windows whose winType does include "minus" are intersected,
(let \eqn{B} be their intersection). Then, provided that
\code{intersect = TRUE} (the default), the returned data.frame will
be the points of \code{x} in the the intersection of
\eqn{A} and \eqn{B}.
Otherwise, if \code{intersect = FALSE}, the returned data.frame
consists of the points of \code{x} in the union of
\eqn{A} and \eqn{B}.

Note that if \eqn{A} (resp. \eqn{B}) is empty then the returned data.frame
will be the points of \code{x} in \eqn{B} (resp. \eqn{A}).
}
\examples{

win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))

cmbdf <- CMBDataFrame(nside = 4)
df2 <- coords(cmbdf, new.coords = "cartesian")
df <- as.data.frame(df2[,1:3])
df
df.win <- window(df, new.window = win1)
df.win

}
