% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partidos.R
\name{fetch_partido}
\alias{fetch_partido}
\title{Fetches parties from API using a query.}
\usage{
fetch_partido(id = NULL, sigla = NULL, dataInicio = NULL,
  dataFim = NULL, idLegislatura = NULL, itens = NULL, ordenarPor = NULL)
}
\arguments{
\item{id}{Party's ID}

\item{sigla}{Party's abbreviation}

\item{dataInicio}{Party's processing starting date}

\item{dataFim}{Party's processing end date}

\item{idLegislatura}{Legislature's number}

\item{itens}{Items quantity. '-1' returns all parties which have
deputies at the request moment}

\item{ordenarPor}{Order by: 'id', 'sigla' or 'nome'}
}
\value{
Dataframe containing information about the parties.
}
\description{
Returns a list containing basic information about parties which has or had been any deputy
in the lower house. If none parameters are passed, the function returns the parties
which has active deputies on that moment.
}
\details{
Note that if you have the party's ID, it's not necessary to add any other parameter on the
function call. The call to this function using the party's ID returns more details than using the
others parameters. If you don't have the party's ID, the \code{\link[rcongresso]{fetch_id_partido}}
function may be helpful.
}
\examples{
PMB <- fetch_partido(id = 36887)
PT <- fetch_partido(sigla = "PT")
partidos2010a2014 <- fetch_partido(dataInicio = "2010-01-01", dataFim = "2014-12-31", itens = 100)
}
\seealso{
\code{\link[rcongresso]{get_votos_partidos}}, \code{\link[rcongresso]{fetch_orientacoes}}
}
