% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_github_actions_check.R
\name{add_github_actions_check}
\alias{add_github_actions_check}
\title{Setup GitHub Actions to check package}
\usage{
add_github_actions_check(open = FALSE, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{open}{a logical value

If \code{TRUE} (default) the file is opened in the editor.}

\item{overwrite}{a logical value

If this file is already present and \code{overwrite = TRUE}, it will be erased
and replaced. Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function creates a configuration file (\code{.yaml}) to setup GitHub Actions
to check the package. This file will be written (from a template adapted
from \code{\link[usethis:use_github_action]{usethis::use_github_action()}}) in the folder
\code{.github/workflows/R-CMD-check.yaml}.
}
\details{
This workflow runs \verb{R CMD check} on the three major operating systems
(Ubuntu, macOS, and Windows) on the latest release of R. If user want to
change this setting he can replace this \code{.yaml} file be another (e.g.
generated by running \code{\link[usethis:use_github_action]{usethis::use_github_action()}}).
}
\examples{
\dontrun{
add_github_actions_check()
}
}
\seealso{
Other development functions: 
\code{\link{add_dependencies}()},
\code{\link{add_github_actions_codecov}()},
\code{\link{add_github_actions_pkgdown}()},
\code{\link{add_r_depend}()},
\code{\link{add_to_buildignore}()},
\code{\link{add_to_gitignore}()}
}
\concept{development functions}
