% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonPairedRC.r
\name{wilcoxonPairedRC}
\alias{wilcoxonPairedRC}
\title{Matched-pairs rank biserial correlation coefficient}
\usage{
wilcoxonPairedRC(
  x,
  g = NULL,
  zero.method = "Wilcoxon",
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A vector of observations.}

\item{g}{The vector of observations for
the grouping, nominal variable.
Only the first two levels of the nominal variable are used.}

\item{zero.method}{If \code{"Wilcoxon"},
differences of zero are discarded and then ranks
are determined.
If \code{"Pratt"},
ranks are determined, 
and then differences of zero are discarded.
 If \code{"none"},
differences of zero are not discarded.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{verbose}{If \code{TRUE}, prints information on sample size and ranks.}

\item{...}{Additional arguments passed to \code{rank}}
}
\value{
A single statistic, rc.  
        Or a small data frame consisting of rc,
        and the lower and upper confidence limits.
}
\description{
Calculates matched-pairs rank biserial correlation coefficient
             effect size
             for paired Wilcoxon signed-rank test; confidence intervals
             by bootstrap.
}
\details{
It is recommended that \code{NA}s be removed
          beforehand.
          
          When the data in the first group are greater than
          in the second group, rc is positive.
          When the data in the second group are greater than
          in the first group, rc is negative.
          
          Be cautious with this interpretation, as R will alphabetize
          groups if \code{g} is not already a factor.
          
          When rc is close to extremes,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Pooh)
Time1 = Pooh$Likert[Pooh$Time==1]
Time2 = Pooh$Likert[Pooh$Time==2]
wilcox.test(x = Time1, y = Time2, paired=TRUE, exact=FALSE)
wilcoxonPairedRC(x = Pooh$Likert, g = Pooh$Time)

### Example from King, Rosopa, and Minium
Placebo = c(24,39,29,28,25,32,31,33,31,22)
Drug    = c(28,29,34,21,28,15,17,28,16,12)
Y = c(Placebo, Drug)
Group = factor(c(rep("Placebo", length(Placebo)),  
                 rep("Drug", length(Drug))), 
                 levels=c("Placebo", "Drug"))
wilcoxonPairedRC(x = Y, g = Group)

### Example with some zero differences
A = c(11,12,13,14,15,16,17,18,19,20)
B = c(12,14,16,18,20,22,12,10,19,20)
Y = c(A, B)
Group = factor(c(rep("A", length(A)),  
                 rep("B", length(B))))
wilcoxonPairedRC(x = Y, g = Group, verbose=TRUE, zero.method="Wilcoxon")
wilcoxonPairedRC(x = Y, g = Group, verbose=TRUE, zero.method="Pratt")
wilcoxonPairedRC(x = Y, g = Group, verbose=TRUE, zero.method="none")

}
\references{
King, B.M., P.J. Rosopa, and E.W. Minium. 2011. 
            Statistical Reasoning in the Behavioral Sciences, 6th ed.
            
            \url{https://rcompanion.org/handbook/F_06.html}
}
\seealso{
\code{\link{wilcoxonPairedR}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Matched-pairs rank biserial correlation}
\concept{Wilcoxon signed rank}
\concept{confidence interval}
\concept{effect size}
