% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_nu_suggest.R
\name{cp_nu_suggest}
\alias{cp_nu_suggest}
\title{Name Usage: Suggest}
\usage{
cp_nu_suggest(
  q,
  dataset_key,
  fuzzy = FALSE,
  min_rank = NULL,
  max_rank = NULL,
  sort = NULL,
  reverse = FALSE,
  accepted = FALSE,
  limit = 10,
  ...
)
}
\arguments{
\item{q}{(character) main query string. required}

\item{dataset_key}{(character) a dataset key. required}

\item{fuzzy}{(logical) Whether or not to do fuzzy search (default: \code{FALSE})}

\item{min_rank, max_rank}{(character) See rank options in \code{\link[=cp_name_match]{cp_name_match()}}}

\item{sort}{(character) one of name, taxonomic, index_name_id, native,
relevance}

\item{reverse}{(logical) reverse order i assume (default: \code{FALSE})}

\item{accepted}{(logical) limit to accepted names (default: \code{FALSE})}

\item{limit}{(integer) requested number of maximum records to be returned.
Default: 10; max: 1000}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
a data.frame/tibble of results. a zero row data.frame if no results
}
\description{
Name Usage: Suggest
}
\examples{
if (cp_up("/dataset/3/nameusage/suggest?q=Apis")) {
cp_nu_suggest(q="Apis", 3)
}
}
