% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{create_collection}
\alias{create_collection}
\title{Create a Collection in ChromaDB}
\usage{
create_collection(
  client,
  name,
  metadata = NULL,
  configuration = NULL,
  tenant = "default_tenant",
  database = "default_database",
  get_or_create = FALSE
)
}
\arguments{
\item{client}{A ChromaDB client object}

\item{name}{The name of the collection}

\item{metadata}{Optional metadata for the collection}

\item{configuration}{Optional configuration for the collection. For HNSW configuration,
use a list with \code{hnsw_space} (e.g., "cosine", "l2", "ip").}

\item{tenant}{The tenant name (default: "default")}

\item{database}{The database name (default: "default")}

\item{get_or_create}{Whether to get the collection if it exists (default: FALSE)}
}
\value{
A collection object
}
\description{
Create a Collection in ChromaDB
}
