% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcheology.R
\name{rcheology}
\alias{rcheology}
\title{Data on objects from current and previous versions of R}
\description{
A data frame with every function (and other object) in versions
of R from 1.0.1 onwards. Variables are:
\itemize{
\item \code{package}: package the object comes from
\item \code{name}: name of the object
\item \code{Rversion}: version of R as major.minor.patch
\item \code{type}: Result of calling \code{\link[=typeof]{typeof()}} on the object
\item \code{class}: \code{\link[=class]{class()}} of the object, separated by slashes if there are multiple classes.
\item \code{exported}: \code{TRUE} if the object name was found in \code{\link[=getNamespaceExports]{getNamespaceExports()}}. True for
anything in the "base" package. \code{NA} if the package does not have a namespace
(e.g. "datasets" in early versions).
\item \code{hidden}: \code{TRUE} if the object name starts with \code{"."}. These objects
are not reported by \code{\link[=ls]{ls()}}.
\item \code{S4generic}: \code{TRUE} if the object is an S4 generic according to
\code{\link[methods:GenericFunctions]{methods::isGeneric()}}. Note that in earlier
versions of rcheology, this column was called \code{generic}.
\item \code{priority}: \code{"base"} for base packages, \code{"recommended"} for recommended
packages. \code{NA} for earlier versions of R (pre 1.6.0) when the priority
concept did not exist.
\item \code{args}: the arguments of the function, or NA for non-functions
}
}
