% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.r
\name{plot_history}
\alias{plot_history}
\title{Plot the history of the scores of each team over time.}
\usage{
plot_history(history, metric, test_name = "quiz", baseline = "baseline",
  col = 1:length(history), pch = rep(21:25, 100), by = 0.05,
  xlab = "Date", ylab = "Score", bty = "l", fg = "darkslategray",
  col.axis = fg, col.lab = fg, text.col = fg, ...)
}
\arguments{
\item{history}{list of the submissions history per team as returned by \code{\link{compute_metrics}}}

\item{metric}{string. name of the metric considered}

\item{test_name}{string. name of the test set used: \code{"quiz"} or \code{"test"}}

\item{baseline}{string. name of the team considered as the baseline. Its best score
will be plotted as a constant and will not appear in the legend.}

\item{col}{colors of the teams}

\item{pch}{symbols of the teams}

\item{by}{real. interval width of grid lines}

\item{xlab,ylab}{axis labels. see \code{\link[graphics]{title}}.}

\item{bty,fg,col.axis,col.lab}{graphical parameters. see \code{\link[graphics]{par}}.}

\item{text.col}{the color used for the legend text. see \code{\link[graphics]{legend}}.}

\item{...}{further parameters passed to \code{\link[graphics]{plot}} function.}
}
\value{
\code{NULL}
}
\description{
The best score of each team has a bold symbol.
}

