% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-fldavg.R, R/cdo-fldcount.R, R/cdo-fldint.R,
%   R/cdo-fldkurt.R, R/cdo-fldmax.R, R/cdo-fldmean.R, R/cdo-fldmedian.R,
%   R/cdo-fldmin.R, R/cdo-fldpctl.R, R/cdo-fldrange.R, R/cdo-fldskew.R,
%   R/cdo-fldstd.R, R/cdo-fldstd1.R, R/cdo-fldsum.R, R/cdo-fldvar.R,
%   R/cdo-fldvar1.R, R/family-fldstat.R
\name{cdo_fldavg}
\alias{cdo_fldavg}
\alias{cdo_fldcount}
\alias{cdo_fldint}
\alias{cdo_fldkurt}
\alias{cdo_fldmax}
\alias{cdo_fldmean}
\alias{cdo_fldmedian}
\alias{cdo_fldmin}
\alias{cdo_fldpctl}
\alias{cdo_fldrange}
\alias{cdo_fldskew}
\alias{cdo_fldstd}
\alias{cdo_fldstd1}
\alias{cdo_fldsum}
\alias{cdo_fldvar}
\alias{cdo_fldvar1}
\alias{fldstat}
\title{Statistical values over a field}
\usage{
cdo_fldavg(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldcount(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldint(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldkurt(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldmax(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldmean(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldmedian(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldmin(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldpctl(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldrange(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldskew(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldstd(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldstd1(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldsum(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldvar(ifile, weights = NULL, p = NULL, ofile = NULL)

cdo_fldvar1(ifile, weights = NULL, p = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{weights}{BOOL - weights=FALSE disables weighting by grid cell area [default: weights=TRUE]}

\item{p}{FLOAT - Percentile number in \{0, ..., 100\}}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module computes statistical values of all input fields. A field is a horizontal layer of a data variable. Depending on the chosen operator, the minimum, maximum, range, sum, integral, average, standard deviation, variance, skewness, kurtosis, median or a certain percentile of the field is written to outfile.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{fldmin     Field minimum
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = min\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldmax     Field maximum
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = max\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldrange   Field range
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = range\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldsum     Field sum
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = sum\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldint     Field integral
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = sum\\\{i(t,x')*cellarea(x'), x_1&lt;x'&lt;=x_n\\\}
fldmean    Field mean
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = mean\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldavg     Field average
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = avg\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldstd     Field standard deviation
           Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = std\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldstd1    Field standard deviation (n-1)
           Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = std1\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldvar     Field variance
           Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = var\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldvar1    Field variance (n-1)
           Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = var1\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
           weighted by area weights obtained by the input field.
fldskew    Field skewness
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = skew\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldkurt    Field kurtosis
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = kurt\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldmedian  Field median
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = median\\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
fldcount   Field count
           Number of non-missing values of the field.
fldpctl    Field percentiles
           For every gridpoint x_1, ..., x_n of the same field it is:
           
           o(t,1) = pth percentile \\\{i(t,x'), x_1&lt;x'&lt;=x_n\\\}
}\if{html}{\out{</div>}}
}
