% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.stKde}
\alias{plot.stKde}
\title{Plot map(s) of the spatio-temporal intensity of radiocarbon dates.}
\usage{
\method{plot}{stKde}(
  x,
  focalyears = NULL,
  type = "focal",
  plotdir = NULL,
  imnames = "byyear",
  zlim = NULL,
  box = FALSE,
  main = "auto",
  col.mask = "grey75",
  ncolours = 256,
  ramptype = "raw",
  imdim = c(10, 10),
  mars = c(0.5, 0.5, 2.5, 2),
  ribbon = TRUE,
  ribargs = list(),
  cex.ribbon = 0.5,
  withpts = "n",
  cex.main = 0.8,
  pch.pts = 19,
  col.pts = "grey50",
  cex.pts = 0.1,
  tidydevs = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class stKde.}

\item{focalyears}{A vector of numeric values for focal years, in calBP, that will be timesteps at which date intensity maps will be plotted.}

\item{type}{A single character string stipulating which type of plot to create. Current options are "nonfocal", "mask", "focal", "proportion", "change" and "all".}

\item{plotdir}{Optional output directory for plots. If NULL, then only a single plot is made to the current device. If a valid output direcotry is provided then one or more timeslices maps are saved as png files (e.g. as source images for an animation).}

\item{imnames}{The format of the output files if output is as png files to a directory. The current two options are "basic" (labelling the images in basic sequence as preferred by animation software such as ffmpeg) or "byyear" (labelling the images by calBP year).}

\item{zlim}{Numeric vector of length=2 which controlls the maximum or minimum of the colour ramp.}

\item{box}{Logical. Plot a border around the map or not.}

\item{main}{Single character string specifying a main title. "auto" implies internal default titles are used.}

\item{col.mask}{The colour used to depict any areas that are being masked out.}

\item{ncolours}{The maximum number of colours to use in the colour ramp.}

\item{ramptype}{What kind of treatment for the colour ramp. Current options are "raw" (do not try to standardise the ramps across timeslices),"std" (standardise each plot, typically by capturing the first 3sd in the main colour ramp and then outliers beyond that with the extreme colours of the ramp),"unl" (do not standardise but plot generalised high/low ramp labels) and "mmx" (scale to the minimum and maximum values across all timeslices).}

\item{imdim}{Height and width of the plot to png in cm.}

\item{mars}{Margins of the plot to png.}

\item{ribbon}{Whether to plot the colour ramp legend or not.}

\item{ribargs}{Whether to plot the colour ramp legend or not.}

\item{cex.ribbon}{The size of the ribbon font.}

\item{withpts}{Plot with the original sample locations shown (current options are "y" and "n").}

\item{cex.main}{The size of the title font.}

\item{pch.pts}{The symbols used for the plotted points.}

\item{col.pts}{The colours used for the plotted points.}

\item{cex.pts}{The size used for the plotted points.}

\item{tidydevs}{Logical for whether to clean up any open grpahics devices or not (default is TRUE).}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}

\item{...}{Additional arguments affecting the plot.}
}
\description{
Plotting function for single or multiple maps of the spatio-temporal intensity of radiocarbon dates at given focal years.
}
\details{
This function plots to a screen device if a single focal year is stipulated and no output directory. Or if an output directory is stipulated, it plots one or more focal years to png files, with some basic formatting options and optional cross-year standardisation of the colour ramps (with a view to them being stills-for-video). For even more control of plotting, call this function one year at a time in a loop.
}
\examples{
\dontrun{
## Example with a subset of English and Welsh dates from the Euroevol dataset
data(ewdates)
data(ewowin)
dir.create(file.path("im"), showWarnings=FALSE)
x <- calibrate(x=ewdates$C14Age, errors=ewdates$C14SD, normalised=FALSE)
bins1 <- binPrep(sites=ewdates$SiteID, ages=ewdates$C14Age, h=50)
stkde1 <- stkde(x=x, coords=ewdates[,c("Eastings", "Northings")], 
win=ewowin, sbw=40000, cellres=2000, focalyears=seq(6500, 5000, -100),
tbw=50, bins=bins1, backsight=200, outdir="im")

## Plot just the proportion surface for just 5900 calBP
plot(stkde1, 5900, type="proportion")

## Plot an example of all four basic outputs for just 5900 calBP
dev.new(height=2.5, width=8)
par(mar=c(0.5, 0.5, 2.5, 2))
plot(stkde1, 5900, type="all")

## Plot standardised change surfaces to a sub-directory called 
## /png for all timeslices and save to file.
dir.create(file.path("png"), showWarnings=FALSE)
plot(stkde1, seq(6500,5000,-100), type="change", ramptype="std", withpts=TRUE, plotdir="png")

## Plot all four summary surfaces in one image, saving them to a sub-directory call 'pngall',
## and with the output of the change map standardised to a common ramp 
## (but leaving the focal and proportion maps unstandardised with simple ramp labelling)
dir.create(file.path("pngall"), showWarnings=FALSE)
plot(stkde1, seq(6500,5000,-100), type="all", ramptype=c("unl","unl","std"), imdim=cm(c(2.5,8)),
withpts=TRUE, plotdir="pngall")
}

}
