% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{spkde}
\alias{spkde}
\title{Map the spatial intensity of a set of radiocarbon dates for a given focal year.}
\usage{
spkde(
  x,
  coords,
  sbw,
  focalyear,
  tbw,
  win,
  cellres,
  bins = NA,
  backsight = NA,
  nsim = NULL,
  maskthresh = 0,
  changexpr = expression((t1 - t0)/tk),
  raw = FALSE,
  spjitter = TRUE,
  amount = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class CalDates with calibrated radiocarbon ages.}

\item{coords}{A two column matrix of geographical coordinates from a a projected coordinate system (no checks are made for this) and with the same number of rows as length(x).}

\item{sbw}{A single numeric value for the spatial bandwidth to be applied around each raster cell, expressed as the standard deviation of a continuous Gaussian kernel (passed as the sigma argument to density.ppp()).}

\item{focalyear}{A single numeric value for the focal year for the intensity map.}

\item{tbw}{A single numeric value for the temporal bandwidth to be applied around each focal year, expressed as the standard deviation of a continuous Gaussian kernel.}

\item{win}{The bounding polygon for the mapping (must be an object of class 'owin', see the spatstat package)}

\item{cellres}{The cell or pixel resolution of the output raster maps.}

\item{bins}{A vector of labels corresponding to site names, ids, bins or phases (same length as x)}

\item{backsight}{A single numeric value (which will be coerced to be positive) that specifies a comparison timestep in the past for a mapping of temporal change.}

\item{nsim}{How many bootstrap simulations to run (default is none).}

\item{maskthresh}{A single numeric value for a lower-bound cut-off for all maps, based on a minimum required spatial intensity of all dates in x.}

\item{changexpr}{An expression for calculating the change in spatial intensity between the focal year and a backsight year (as defined via the backsight argument). Available input options are t1 (the spatial intensity for the focal year), t0 (the spatial intensity for the backsight year) and tk (the overall spatial intensity for all dates irrespective of year), plus any other standard constants and mathematical operators. A sensible default is provided.}

\item{raw}{Whether to output the raw simulations (if nsim is set) or just the summaries (the latter is default).}

\item{spjitter}{Whether noise is applied to the spatial coordinates or not. Default is TRUE.}

\item{amount}{Amount of jitter applied to the spatial coordinates when \code{spjitter=TRUE}. Default is d/5, where d is difference between the closest coordinates.}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}

\item{...}{ignored or passed to internal functions.}
}
\value{
A list object of class spKde with the following elements:
\itemize{
\item {A series of list items storing some of the input parameters such as the focal year, sbw, tbw, backsight, maskthresh.} 
\item{\code{nonfocal}} {An im object mapping the basic spatial intensity of all dates, without reference to a focal year.} 
\item{\code{focal}} {An im object mapping the spatial intensity of dates for the focal year (i.e. weighted by how much each dates probability distribution overlaps with a Gaussian kernel centred on the focal year with a standard deviation of tbw).}
\item{\code{proportion}} {An im object mapping the proportional intensity of dates for the focal year (i.e. the focal surface divided by the nonfocal surface).}
\item{\code{change}} {An im object mapping the amount of change between the intensity of dates for the focal year and a chosen backsight year (i.e. as defined by changexpr).}
}
}
\description{
Function for mapping the spatial intensity of radiocarbon dates for a given geographical region and focal year.
}
\details{
This function is not really intended for general use, but rather as an internal function for stkde(). Most applications should use the latter, but spkde has been exported and made externally available, both because this function retains the result in memory (in contrast to stkde) and with a view to possible addition of bootstrap methods in the future. Some function arguments therefore remain experimental. The function computes timeslice maps of the spatio-temporal kernel intensity of radiocarbon dates across a geographic region for a specific focal year. The user specifies the arbitrary size of both the spatial and the temporal Gaussian kernels that will be used to summarise radiocarbon date intensity per grid cell.
}
\examples{
\dontrun{
## Example for the focal year 5600 calBP (also with site binning), 
## using a subset of English and Welsh dates from the Euroevol dataset
data(ewdates)
data(ewowin)
x <- calibrate(x=ewdates$C14Age, errors=ewdates$C14SD, normalised=FALSE)
bins1 <- binPrep(sites=ewdates$SiteID, ages=ewdates$C14Age, h=50)
spkde1 <- spkde(x=x, coords=ewdates[,c("Eastings", "Northings")], win=ewowin, 
sbw=40000, cellres=2000, focalyear=5600, tbw=50, bins=bins1, backsight=200,amount=1)
plot(spkde1$focal)
plot(spkde1$proportion)
}

}
