% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{as.CalGrid}
\alias{as.CalGrid}
\title{Convert data to class CalGrid.}
\usage{
as.CalGrid(x)
}
\arguments{
\item{x}{A two-column \code{matrix} or \code{data.frame} class object.}
}
\value{
A CalGrid class object of probabilities or summed probabilities per calendar year BP.
}
\description{
Tries to coerce any two-column matrix or data.frame to a calibrated probability distribution (an object of class "CalGrid") for use by the rcarbon package.
}
\examples{
df <- data.frame(calBP=5000:2000,PrDens=runif(length(5000:2000)))
mycalgrid <- as.CalGrid(df)
plot(mycalgrid)
}
