% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{barCodes}
\alias{barCodes}
\title{Plot the median values of calibrated radiocarbon dates or bins}
\usage{
barCodes(
  x,
  yrng = c(0, 0.03),
  width = 20,
  col = rgb(0, 0, 0, 25, maxColorValue = 255),
  border = NA,
  ...
)
}
\arguments{
\item{x}{A vector containing median values obtained from \code{\link{medCal}} or \code{\link{binMed}}}

\item{yrng}{y-axis range of the bars.}

\item{width}{width of the bars (optional)}

\item{col}{color of the bars}

\item{border}{the color to draw the border. Use border = NA to omit borders.}

\item{...}{Additional arguments affecting the plot}
}
\description{
Plot the median values of multiple calibrated radiocarbon dates or bins in a barcode-like strip.
}
\examples{
\dontrun{
#Load EUROEVOL Data
data(euroevol)

#Subset Danish Dates
denmark <- subset(euroevol,Country=="Denmark")

#Calibrate and Bin
denmarkDates <- calibrate(x=denmark$C14Age,errors=denmark$C14SD) 
denmarkBins <- binPrep(sites=denmark$SiteID,ages=denmark$C14Age,h=200) #200 years bin size

#Compute median date for each bin
bm <- binMed(x=denmarkDates,bins=denmarkBins)

#Compute median date for each date
dm <- medCal(denmarkDates)

#Compute SPD 
denmarkSPD <- spd(x=denmarkDates,bins=denmarkBins,timeRange=c(10000,4000))

#Plot SPD and barCodes of median dates
plot(denmarkSPD,runm=200)
barCodes(dm,yrng=c(0,0.01)) 

#Plot SPD and barCodes of median bins in BC/AD
plot(denmarkSPD,runm=200,calendar="BCAD")
barCodes(BPtoBCAD(bm),yrng=c(0,0.01)) 
}
}
\seealso{
\code{\link{medCal}}; \code{\link{binMed}}
}
