% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie_sky_model_raster.R
\name{cie_sky_model_raster}
\alias{cie_sky_model_raster}
\title{CIE sky model raster}
\usage{
cie_sky_model_raster(z, a, sun_coord, sky_coef)
}
\arguments{
\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{sun_coord}{Numeric vector of length two. The solar disk
center represented with zenith and azimuth angles in degrees.}

\item{sky_coef}{Numeric vector of length five. Parameters of the sky model.}
}
\description{
CIE sky model raster
}
\examples{
z <- zenith_image(50, lens())
a <- azimuth_image(z)
path <- system.file("external", package = "rcaiman")
skies <- read.csv(file.path(path, "15_CIE_standard_skies.csv"))
# parameters are from http://dx.doi.org/10.1016/j.energy.2016.02.054
sky_coef <- skies[4,1:5]
sun_coord <- c(45, 0)
plot(cie_sky_model_raster(z, a, sun_coord, sky_coef))
}
\seealso{
Other Sky Reconstruction Functions: 
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{interpolate_sky_points}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
