% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtree.R
\name{qtree}
\alias{qtree}
\title{Quad-tree segmentation}
\usage{
qtree(r, scale_parameter = 0.2)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}.}

\item{scale_parameter}{Numeric vector of length one. Quad-tree is a top-down
method. This parameter controls the stopping condition. Therefore, it
allows controlling the size of the resulting segments. Ultimately, segments
sizes will depend on both this parameter and the heterogeneity of \code{r}.}
}
\value{
A single layer image of the class \linkS4class{SpatRaster} with
  integer values.
}
\description{
The quad-tree segmentation algorithm is a top-down process that makes
recursive divisions in four equal parts until a condition is satisfied and
stops locally. This is the usual implementation of the quad-tree algorithm,
so it produces squared segments of different sizes. This particular
implementation allows up to five sizes.
}
\details{
The algorithm starts splitting the entire image into large squared segments
following, depending on the aspect ratio, grids going from \eqn{4 \times 4}
to \eqn{1 \times 4}/\eqn{4 \times 1}; then, splits each segment into four
sub-segments and calculates the standard deviation of the pixels from
\code{r} delimited by each of those segments. The splitting process stops
locally if the sum of the standard deviation of the sub-segments minus the
standard deviation of the parent segment (named \emph{delta}) is less or
equal than the \code{scale_parameter}. If \code{r} has more than one layer,
\emph{delta} is calculated separately and \emph{delta} mean is used to
evaluate the stopping condition.
}
\examples{
\dontrun{
caim <- read_caim()
plot(caim)
caim <- normalize(caim, 0, 255)
seg <- qtree(caim, scale_parameter = 0.5)
plot(caim$Blue)
plot(extract_feature(caim$Blue, seg))
plot(extract_feature(seg, seg, length))
}
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{mask_sunlit_canopy}()},
\code{\link{polar_qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
