% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_noncircular.R
\name{expand_noncircular}
\alias{expand_noncircular}
\title{Expand non-circular}
\usage{
expand_noncircular(caim, z, zenith_colrow)
}
\arguments{
\item{caim}{\linkS4class{RasterBrick}. The return of a call to
\code{\link{read_caim}}.}

\item{z}{\linkS4class{RasterLayer} built with
\code{\link{zenith_image}}.}

\item{zenith_colrow}{Numeric vector of length two. Raster coordinates of the
zenith. See \code{\link{calc_zenith_raster_coordinates}}.}
}
\value{
An object of class \linkS4class{RasterBrick} that is the result of
  copying the pixels from \code{caim} and adding margins of \code{NA} pixel
  values. The zenith point depicted in the picture should be in the center of
  the image or very close to it.
}
\description{
Expand a non-circular hemispherical photograph.
}
\examples{
\dontrun{
   my_file <- file.path(tmpDir(), "DSC_2881.JPG")
   download.file("https://osf.io/x8urg/download", my_file,
               method = "auto", mode = "wb"
   )

   r <- read_caim(my_file)
   diameter <- calc_diameter(lens("Nikkor_10.5_mm"), 1202, 53)
   zenith_colrow <- c(1503, 998)
   z <- zenith_image(diameter, lens("Nikkor_10.5_mm"))
   r <- expand_noncircular(r, z, zenith_colrow)
   plot(r)
}
}
\seealso{
Other Lens functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coordinates}()},
\code{\link{calibrate_lens}()},
\code{\link{lens}()},
\code{\link{reproject_to_equidistant}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
