% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc.R
\name{rankings}
\alias{rankings}
\title{Evaluate rankings}
\usage{
rankings(x, k.max)
}
\arguments{
\item{x}{Numeric matrix.}

\item{k.max}{Integer. Indices of k.max largest elements are returned.}
}
\value{
Matrix with the indices corresponding to the \code{k.max} largest values in \code{x}.
}
\description{
Returns the non-increasing order of the values in the columns of \code{x}. Ties are solved at random.
}
\examples{
omega <- abs(matrix(rnorm(100*5), nrow = 10, ncol = 5))
rankings(omega, k.max = 10)
}

