% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rbvs.R
\name{rbvs}
\alias{rbvs}
\alias{rbvs.default}
\title{Ranking-Based Variable Selection}
\usage{
rbvs(x, y, ...)

\method{rbvs}{default}(x, y, m, B = 500, measure = c("pc", "dc", "lasso",
  "mcplus", "user"), fun = NULL, s.est = s.est.quotient, iterative = TRUE,
  use.residuals = TRUE, k.max, min.max.freq = 0, max.iter = 10,
  verbose = TRUE, ...)
}
\arguments{
\item{x}{Matrix with \code{n} observations of \code{p} covariates in each row.}

\item{y}{Response vector with \code{n} observations.}

\item{...}{Other parameters that may be passed to \code{fun} and\code{s.est}.}

\item{m}{Subsample size used in the RBVS algorithm.}

\item{B}{Number of sample splits.}

\item{measure}{Character with the name of the method used to measure the association between
the response and the covariates. See Details below.}

\item{fun}{Function used to evaluate the measure given in \code{measure}. It is required when
method=="user". Must have at least three arguments: \code{x} (covariates matrix),  \code{.y} (response vector), \code{subsamples} (a matrix, each row contains indices of the observations to be used); return a vector of the same length as
the number of covariates in \code{.x}. See for example \code{\link{pearson.cor}} or \code{\link{lasso.coef}}.}

\item{s.est}{Function used to estimate the number of important covariates based on the RBVS path. Must accept \code{probs} (a vector with probabilities) as an argument. See \code{\link{s.est.quotient}} and Details below.}

\item{iterative}{Logical variable indicating the type of the procedure. If \code{TRUE}, an iterative extension of the RBVS algorithm is launched.}

\item{use.residuals}{Logical. If true, the impact of the previously detected variables is removed from the response in the IRBVS procedure.}

\item{k.max}{Maximum size of the subset of important variables..}

\item{min.max.freq}{Positive integer. Optional parameter - the algorithm stops searching for the most frequent set when the frequencies reach this value.}

\item{max.iter}{Maximum number of iterations fot the IRBVS algorithm.}

\item{verbose}{Logical indicating wheter the progress of the algorithm should be reported.}
}
\value{
Object of class rbvs with the following fields
\item{measure}{Character indicating type of measure used.}
\item{score}{List with scores at each iteration.}
\item{subsets}{A list with subset candidates at each iteration.}
\item{frequencies}{A list with observed frequencies at each iteration.}
\item{ranks}{Rankings evaluated (for the last iteration \code{iterative=TRUE})}
\item{s.hat}{Vector with the number of the covariates selected at each iteration.}
\item{active}{Vector with the selected covariates.}
\item{timings}{Vector reporting the amount of time the (I)RBVS algorithm took at each iteration.}
}
\description{
Performs Rankings-Based Variable Selection using various measures of the dependence between the predictors and the response.
}
\details{
Currently supported measures are: Pearson correlation coefficient (\code{measure="pc"}), Distance Correlation (\code{measure="dc"}), the regression coefficients estimated via Lasso (\code{measure="lasso"}), the regression coefficients estimated via MC+ (\code{measure="mcplus"}).
}
\examples{
set.seed(1)

x <- matrix(rnorm(200*1000),200,1000)
active <- 1:4
beta <- c(3,2.5,-1.7,-1)
y <- 1*rnorm(200) +x[,active]\%*\%beta
#RBVS algorithm
rbvs.object <- rbvs(x,y, iterative=FALSE)
rbvs.object$active
rbvs.object$subsets[[1]][[4]]
#IRBVS algorithm
rbvs.object <- rbvs(x,y)
rbvs.object$active
}
\references{
R. Baranowski, P. Fryzlewicz (2015), Ranking-Based Variable Selection, in submission (\url{http://personal.lse.ac.uk/baranows/rbvs/rbvs.pdf)}).
}

