% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bison}
\alias{bison}
\title{Search for and collect data from the USGS Bison API.}
\usage{
bison(species = NULL, type = "scientific_name", tsn = NULL,
  start = NULL, count = 10, countyFips = NULL, county = NULL,
  state = NULL, aoi = NULL, aoibbox = NULL, params = NULL,
  what = "all", ...)
}
\arguments{
\item{species}{(character) A species name.}

\item{type}{(character) Type, one of scientific_name or common_name.}

\item{tsn}{(numeric) Specifies the TSN to query by. If you supply a tsn it doesn't make sense to
supply a species name as well. Example:162003.}

\item{start}{(numeric) Record to start at.}

\item{count}{(numeric) Number of records to return.}

\item{countyFips}{(character) Specifies the county fips code to geographically constrain
the search to one county. Character must be supplied as a number starting
with zero may lose the zero. Eg: "49015".}

\item{county}{(character) County name. As codes are a pain in the ass, you can put in the
county name here instead of specifying a countyFips entry, and bison will
attempt to look up the countyFips code. (character)}

\item{state}{(character) Specifies the state name to geographically constrain the search.
Example: Tennessee.}

\item{aoi}{Specifies a WKT (Well-Known Text) polygon to geographically constrain the search.
Eg.: c(-111.06 38.84,
       -110.80 39.377,
       -110.20 39.17,
       -110.20 38.90,
       -110.63 38.67,
       -111.06 38.84),
which calls up the occurrences within the specified area. Check out the Wikipedia
page here \url{http://en.wikipedia.org/wiki/Well-known_text} for an in depth
look at the options, terminology, etc. (character)}

\item{aoibbox}{Specifies a four-sided bounding box to geographically constrain
the search (using format: minx,miny,maxx,maxy). The coordinates are Spherical
Mercator with a datum of WGS84. Example: -111.31,38.81,-110.57,39.21 (character)}

\item{params}{(character) String of parameters, one of providerID, resourceID, basisOfRecord,
catalogNumber, year, computedStateFips, hierarchy_homonym_string, TSNs, recordedBy,
occurrenceID, collectorNumber, provider, ownerInstitutionCollectionCode, eventDate,
providedScientificName, scientificName, ITISscientificName, providedCommonName,
ITIScommonName, kingdom, ITIStsn, centroid, higherGeographyID, computedCountyFips,
providedCounty, calculatedCounty, stateProvince, calculatedState, countryCode. See examples.}

\item{what}{What to return?  One of 'all', 'summary', 'points', 'counties', 'states',
'raw', or 'list'. All data is returned from the BISON API, but this parameter lets
you select just the parts you want, and the rest is discarded before returning the
result to you.}

\item{...}{Further args passed on to httr::GET. See examples.}
}
\description{
Search for and collect data from the USGS Bison API.
}
\examples{
\donttest{
bison(species="Bison bison", count=50, what='summary')
bison(species="Bison bison", count=50, what='points')
}
}
\seealso{
\code{\link{bison_solr}} \code{\link{bison_tax}}
}

