% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtree.r
\name{subtree}
\alias{subtree}
\title{Create a subtree by specifying tips to keep.}
\usage{
subtree(tree, tips)
}
\arguments{
\item{tree}{A phylo object, as returned from \link{read.tree}.}

\item{tips}{A character, numeric, or logical vector of tips to keep.}
}
\value{
A \code{phylo} object for the subtree.
}
\description{
Create a subtree by specifying tips to keep.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "newick.tre", package = "rbiom")
    tree <- read.tree(infile)
    
    leafs   <- tips(tree)
    subtree <- subtree(tree, head(leafs))

}
