% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.r
\name{subset}
\alias{subset}
\alias{subset.BIOM}
\title{Subset samples using the BIOM object's metadata}
\usage{
\method{subset}{BIOM}(x, ...)
}
\arguments{
\item{x}{A BIOM object, as returned from \link{read.biom}.}

\item{...}{Test to run on the metadata to identify samples to retain.}
}
\value{
A \code{BIOM} object.
}
\description{
Subset samples using the BIOM object's metadata
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.biom", package = "rbiom")
    biom <- read.biom(infile)
    
    ex1 <- subset(biom, Age > 30)
    ex2 <- subset(biom, `Body Site` \%in\% c("Saliva", "Stool"))
    ex3 <- subset(biom, Age < 25 & BMI > 22)

}
\seealso{
\code{\link{select}}
}
